package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.trade.repaybill.order.close response.
 * 
 * @author auto create
 * @since 1.0, 2020-03-29 20:20:11
 */
public class AlipayTradeRepaybillOrderCloseResponse extends AlipayResponse {

	private static final long serialVersionUID = 4459143497648727831L;

	/** 
	 * 支付宝账单编号
	 */
	@ApiField("bill_no")
	private String billNo;

	/** 
	 * 还款的资金单号，后续用该单号去调用支付宝收银台sdk进行支付
	 */
	@ApiField("repay_fund_order_no")
	private String repayFundOrderNo;

	/** 
	 * 订单还款状态 ("INIT", "初始"),("PROCESSING", "处理中")("SUCCESS", "成功"),("CLOSE", "关闭");
	 */
	@ApiField("repay_order_status")
	private String repayOrderStatus;

	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}
	public String getBillNo( ) {
		return this.billNo;
	}

	public void setRepayFundOrderNo(String repayFundOrderNo) {
		this.repayFundOrderNo = repayFundOrderNo;
	}
	public String getRepayFundOrderNo( ) {
		return this.repayFundOrderNo;
	}

	public void setRepayOrderStatus(String repayOrderStatus) {
		this.repayOrderStatus = repayOrderStatus;
	}
	public String getRepayOrderStatus( ) {
		return this.repayOrderStatus;
	}

}
