/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateCheckRunRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="annotations")
    private List<Annotations> annotations;
    @Body
    @NameInMap(value="completedAt")
    private String completedAt;
    @Body
    @NameInMap(value="conclusion")
    private String conclusion;
    @Body
    @NameInMap(value="detailsUrl")
    private String detailsUrl;
    @Body
    @NameInMap(value="externalId")
    private String externalId;
    @Body
    @NameInMap(value="headSha")
    @Validation(required=true)
    private String headSha;
    @Body
    @NameInMap(value="name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="output")
    private Output output;
    @Body
    @NameInMap(value="startedAt")
    private String startedAt;
    @Body
    @NameInMap(value="status")
    private String status;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private CreateCheckRunRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.annotations = builder.annotations;
        this.completedAt = builder.completedAt;
        this.conclusion = builder.conclusion;
        this.detailsUrl = builder.detailsUrl;
        this.externalId = builder.externalId;
        this.headSha = builder.headSha;
        this.name = builder.name;
        this.output = builder.output;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.organizationId = builder.organizationId;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateCheckRunRequest create() {
        return CreateCheckRunRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public List<Annotations> getAnnotations() {
        return this.annotations;
    }

    public String getCompletedAt() {
        return this.completedAt;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public String getName() {
        return this.name;
    }

    public Output getOutput() {
        return this.output;
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public String getStatus() {
        return this.status;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static class Output
    extends TeaModel {
        @NameInMap(value="images")
        private List<Images> images;
        @NameInMap(value="summary")
        @Validation(required=true)
        private String summary;
        @NameInMap(value="text")
        private String text;
        @NameInMap(value="title")
        @Validation(required=true)
        private String title;

        private Output(Builder builder) {
            this.images = builder.images;
            this.summary = builder.summary;
            this.text = builder.text;
            this.title = builder.title;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Output create() {
            return Output.builder().build();
        }

        public List<Images> getImages() {
            return this.images;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getText() {
            return this.text;
        }

        public String getTitle() {
            return this.title;
        }

        public static final class Builder {
            private List<Images> images;
            private String summary;
            private String text;
            private String title;

            public Builder images(List<Images> images) {
                this.images = images;
                return this;
            }

            public Builder summary(String summary) {
                this.summary = summary;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Output build() {
                return new Output(this);
            }
        }
    }

    public static class Images
    extends TeaModel {
        @NameInMap(value="alt")
        @Validation(required=true)
        private String alt;
        @NameInMap(value="caption")
        private String caption;
        @NameInMap(value="imageUrl")
        @Validation(required=true)
        private String imageUrl;

        private Images(Builder builder) {
            this.alt = builder.alt;
            this.caption = builder.caption;
            this.imageUrl = builder.imageUrl;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Images create() {
            return Images.builder().build();
        }

        public String getAlt() {
            return this.alt;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public static final class Builder {
            private String alt;
            private String caption;
            private String imageUrl;

            public Builder alt(String alt) {
                this.alt = alt;
                return this;
            }

            public Builder caption(String caption) {
                this.caption = caption;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Images build() {
                return new Images(this);
            }
        }
    }

    public static class Annotations
    extends TeaModel {
        @NameInMap(value="annotationLevel")
        @Validation(required=true)
        private String annotationLevel;
        @NameInMap(value="endColumn")
        private Long endColumn;
        @NameInMap(value="endLine")
        @Validation(required=true)
        private Long endLine;
        @NameInMap(value="message")
        @Validation(required=true)
        private String message;
        @NameInMap(value="path")
        @Validation(required=true)
        private String path;
        @NameInMap(value="rawDetails")
        private String rawDetails;
        @NameInMap(value="startColumn")
        private Long startColumn;
        @NameInMap(value="startLine")
        @Validation(required=true)
        private Long startLine;
        @NameInMap(value="title")
        private String title;

        private Annotations(Builder builder) {
            this.annotationLevel = builder.annotationLevel;
            this.endColumn = builder.endColumn;
            this.endLine = builder.endLine;
            this.message = builder.message;
            this.path = builder.path;
            this.rawDetails = builder.rawDetails;
            this.startColumn = builder.startColumn;
            this.startLine = builder.startLine;
            this.title = builder.title;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Annotations create() {
            return Annotations.builder().build();
        }

        public String getAnnotationLevel() {
            return this.annotationLevel;
        }

        public Long getEndColumn() {
            return this.endColumn;
        }

        public Long getEndLine() {
            return this.endLine;
        }

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public String getRawDetails() {
            return this.rawDetails;
        }

        public Long getStartColumn() {
            return this.startColumn;
        }

        public Long getStartLine() {
            return this.startLine;
        }

        public String getTitle() {
            return this.title;
        }

        public static final class Builder {
            private String annotationLevel;
            private Long endColumn;
            private Long endLine;
            private String message;
            private String path;
            private String rawDetails;
            private Long startColumn;
            private Long startLine;
            private String title;

            public Builder annotationLevel(String annotationLevel) {
                this.annotationLevel = annotationLevel;
                return this;
            }

            public Builder endColumn(Long endColumn) {
                this.endColumn = endColumn;
                return this;
            }

            public Builder endLine(Long endLine) {
                this.endLine = endLine;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder rawDetails(String rawDetails) {
                this.rawDetails = rawDetails;
                return this;
            }

            public Builder startColumn(Long startColumn) {
                this.startColumn = startColumn;
                return this;
            }

            public Builder startLine(Long startLine) {
                this.startLine = startLine;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Annotations build() {
                return new Annotations(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateCheckRunRequest, Builder> {
        private String accessToken;
        private List<Annotations> annotations;
        private String completedAt;
        private String conclusion;
        private String detailsUrl;
        private String externalId;
        private String headSha;
        private String name;
        private Output output;
        private String startedAt;
        private String status;
        private String organizationId;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(CreateCheckRunRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.annotations = request.annotations;
            this.completedAt = request.completedAt;
            this.conclusion = request.conclusion;
            this.detailsUrl = request.detailsUrl;
            this.externalId = request.externalId;
            this.headSha = request.headSha;
            this.name = request.name;
            this.output = request.output;
            this.startedAt = request.startedAt;
            this.status = request.status;
            this.organizationId = request.organizationId;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder annotations(List<Annotations> annotations) {
            this.putBodyParameter("annotations", annotations);
            this.annotations = annotations;
            return this;
        }

        public Builder completedAt(String completedAt) {
            this.putBodyParameter("completedAt", completedAt);
            this.completedAt = completedAt;
            return this;
        }

        public Builder conclusion(String conclusion) {
            this.putBodyParameter("conclusion", conclusion);
            this.conclusion = conclusion;
            return this;
        }

        public Builder detailsUrl(String detailsUrl) {
            this.putBodyParameter("detailsUrl", detailsUrl);
            this.detailsUrl = detailsUrl;
            return this;
        }

        public Builder externalId(String externalId) {
            this.putBodyParameter("externalId", externalId);
            this.externalId = externalId;
            return this;
        }

        public Builder headSha(String headSha) {
            this.putBodyParameter("headSha", headSha);
            this.headSha = headSha;
            return this;
        }

        public Builder name(String name) {
            this.putBodyParameter("name", name);
            this.name = name;
            return this;
        }

        public Builder output(Output output) {
            this.putBodyParameter("output", (Object)output);
            this.output = output;
            return this;
        }

        public Builder startedAt(String startedAt) {
            this.putBodyParameter("startedAt", startedAt);
            this.startedAt = startedAt;
            return this;
        }

        public Builder status(String status) {
            this.putBodyParameter("status", status);
            this.status = status;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public CreateCheckRunRequest build() {
            return new CreateCheckRunRequest(this);
        }
    }
}

