/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateCommitWithMultipleFilesRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="actions")
    @Validation(required=true)
    private List<Actions> actions;
    @Body
    @NameInMap(value="branch")
    @Validation(required=true)
    private String branch;
    @Body
    @NameInMap(value="commitMessage")
    private String commitMessage;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private CreateCommitWithMultipleFilesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.actions = builder.actions;
        this.branch = builder.branch;
        this.commitMessage = builder.commitMessage;
        this.organizationId = builder.organizationId;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateCommitWithMultipleFilesRequest create() {
        return CreateCommitWithMultipleFilesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public List<Actions> getActions() {
        return this.actions;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static class Actions
    extends TeaModel {
        @NameInMap(value="action")
        private String action;
        @NameInMap(value="content")
        private String content;
        @NameInMap(value="filePath")
        private String filePath;
        @NameInMap(value="previousPath")
        private String previousPath;

        private Actions(Builder builder) {
            this.action = builder.action;
            this.content = builder.content;
            this.filePath = builder.filePath;
            this.previousPath = builder.previousPath;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Actions create() {
            return Actions.builder().build();
        }

        public String getAction() {
            return this.action;
        }

        public String getContent() {
            return this.content;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getPreviousPath() {
            return this.previousPath;
        }

        public static final class Builder {
            private String action;
            private String content;
            private String filePath;
            private String previousPath;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder filePath(String filePath) {
                this.filePath = filePath;
                return this;
            }

            public Builder previousPath(String previousPath) {
                this.previousPath = previousPath;
                return this;
            }

            public Actions build() {
                return new Actions(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateCommitWithMultipleFilesRequest, Builder> {
        private String accessToken;
        private List<Actions> actions;
        private String branch;
        private String commitMessage;
        private String organizationId;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(CreateCommitWithMultipleFilesRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.actions = request.actions;
            this.branch = request.branch;
            this.commitMessage = request.commitMessage;
            this.organizationId = request.organizationId;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder actions(List<Actions> actions) {
            this.putBodyParameter("actions", actions);
            this.actions = actions;
            return this;
        }

        public Builder branch(String branch) {
            this.putBodyParameter("branch", branch);
            this.branch = branch;
            return this;
        }

        public Builder commitMessage(String commitMessage) {
            this.putBodyParameter("commitMessage", commitMessage);
            this.commitMessage = commitMessage;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public CreateCommitWithMultipleFilesRequest build() {
            return new CreateCommitWithMultipleFilesRequest(this);
        }
    }
}

