/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateRepositoryGroupRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="avatarUrl")
    private String avatarUrl;
    @Body
    @NameInMap(value="description")
    private String description;
    @Body
    @NameInMap(value="name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="parentId")
    @Validation(required=true)
    private Long parentId;
    @Body
    @NameInMap(value="path")
    @Validation(required=true)
    private String path;
    @Body
    @NameInMap(value="visibilityLevel")
    @Validation(required=true)
    private Integer visibilityLevel;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private CreateRepositoryGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.avatarUrl = builder.avatarUrl;
        this.description = builder.description;
        this.name = builder.name;
        this.parentId = builder.parentId;
        this.path = builder.path;
        this.visibilityLevel = builder.visibilityLevel;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateRepositoryGroupRequest create() {
        return CreateRepositoryGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static final class Builder
    extends Request.Builder<CreateRepositoryGroupRequest, Builder> {
        private String accessToken;
        private String avatarUrl;
        private String description;
        private String name;
        private Long parentId;
        private String path;
        private Integer visibilityLevel;
        private String organizationId;

        private Builder() {
        }

        private Builder(CreateRepositoryGroupRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.avatarUrl = request.avatarUrl;
            this.description = request.description;
            this.name = request.name;
            this.parentId = request.parentId;
            this.path = request.path;
            this.visibilityLevel = request.visibilityLevel;
            this.organizationId = request.organizationId;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder avatarUrl(String avatarUrl) {
            this.putBodyParameter("avatarUrl", avatarUrl);
            this.avatarUrl = avatarUrl;
            return this;
        }

        public Builder description(String description) {
            this.putBodyParameter("description", description);
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.putBodyParameter("name", name);
            this.name = name;
            return this;
        }

        public Builder parentId(Long parentId) {
            this.putBodyParameter("parentId", parentId);
            this.parentId = parentId;
            return this;
        }

        public Builder path(String path) {
            this.putBodyParameter("path", path);
            this.path = path;
            return this;
        }

        public Builder visibilityLevel(Integer visibilityLevel) {
            this.putBodyParameter("visibilityLevel", visibilityLevel);
            this.visibilityLevel = visibilityLevel;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public CreateRepositoryGroupRequest build() {
            return new CreateRepositoryGroupRequest(this);
        }
    }
}

