/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetCheckRunRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="checkRunId")
    @Validation(required=true)
    private Long checkRunId;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private GetCheckRunRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.checkRunId = builder.checkRunId;
        this.organizationId = builder.organizationId;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetCheckRunRequest create() {
        return GetCheckRunRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getCheckRunId() {
        return this.checkRunId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static final class Builder
    extends Request.Builder<GetCheckRunRequest, Builder> {
        private String accessToken;
        private Long checkRunId;
        private String organizationId;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(GetCheckRunRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.checkRunId = request.checkRunId;
            this.organizationId = request.organizationId;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder checkRunId(Long checkRunId) {
            this.putQueryParameter("checkRunId", checkRunId);
            this.checkRunId = checkRunId;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public GetCheckRunRequest build() {
            return new GetCheckRunRequest(this);
        }
    }
}

