/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class LinkMergeRequestLabelRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="labelIds")
    @Validation(required=true)
    private List<String> labelIds;
    @Query
    @NameInMap(value="localId")
    @Validation(required=true)
    private Long localId;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private LinkMergeRequestLabelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.labelIds = builder.labelIds;
        this.localId = builder.localId;
        this.organizationId = builder.organizationId;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LinkMergeRequestLabelRequest create() {
        return LinkMergeRequestLabelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public List<String> getLabelIds() {
        return this.labelIds;
    }

    public Long getLocalId() {
        return this.localId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static final class Builder
    extends Request.Builder<LinkMergeRequestLabelRequest, Builder> {
        private String accessToken;
        private List<String> labelIds;
        private Long localId;
        private String organizationId;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(LinkMergeRequestLabelRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.labelIds = request.labelIds;
            this.localId = request.localId;
            this.organizationId = request.organizationId;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder labelIds(List<String> labelIds) {
            this.putBodyParameter("labelIds", labelIds);
            this.labelIds = labelIds;
            return this;
        }

        public Builder localId(Long localId) {
            this.putQueryParameter("localId", localId);
            this.localId = localId;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public LinkMergeRequestLabelRequest build() {
            return new LinkMergeRequestLabelRequest(this);
        }
    }
}

