/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListApplicationsRequest
extends Request {
    @Query
    @NameInMap(value="nextToken")
    private String nextToken;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    private String organizationId;
    @Query
    @NameInMap(value="pagination")
    private String pagination;
    @Query
    @NameInMap(value="perPage")
    private Integer perPage;
    @Query
    @NameInMap(value="sort")
    private String sort;

    private ListApplicationsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.pagination = builder.pagination;
        this.perPage = builder.perPage;
        this.sort = builder.sort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListApplicationsRequest create() {
        return ListApplicationsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getPagination() {
        return this.pagination;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public String getSort() {
        return this.sort;
    }

    public static final class Builder
    extends Request.Builder<ListApplicationsRequest, Builder> {
        private String nextToken;
        private String orderBy;
        private String organizationId;
        private String pagination;
        private Integer perPage;
        private String sort;

        private Builder() {
        }

        private Builder(ListApplicationsRequest request) {
            super((Request)request);
            this.nextToken = request.nextToken;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.pagination = request.pagination;
            this.perPage = request.perPage;
            this.sort = request.sort;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("nextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder pagination(String pagination) {
            this.putQueryParameter("pagination", pagination);
            this.pagination = pagination;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.putQueryParameter("perPage", perPage);
            this.perPage = perPage;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }
}

