/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListCheckRunsRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="ref")
    @Validation(required=true)
    private String ref;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private ListCheckRunsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.ref = builder.ref;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListCheckRunsRequest create() {
        return ListCheckRunsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getRef() {
        return this.ref;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static final class Builder
    extends Request.Builder<ListCheckRunsRequest, Builder> {
        private String accessToken;
        private String organizationId;
        private Long page;
        private Long pageSize;
        private String ref;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(ListCheckRunsRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.ref = request.ref;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder ref(String ref) {
            this.putQueryParameter("ref", ref);
            this.ref = ref;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public ListCheckRunsRequest build() {
            return new ListCheckRunsRequest(this);
        }
    }
}

