/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListGroupRepositoriesRequest
extends Request {
    @Path
    @NameInMap(value="groupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="search")
    private String search;

    private ListGroupRepositoriesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupId = builder.groupId;
        this.accessToken = builder.accessToken;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.search = builder.search;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListGroupRepositoriesRequest create() {
        return ListGroupRepositoriesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSearch() {
        return this.search;
    }

    public static final class Builder
    extends Request.Builder<ListGroupRepositoriesRequest, Builder> {
        private String groupId;
        private String accessToken;
        private String organizationId;
        private Long page;
        private Long pageSize;
        private String search;

        private Builder() {
        }

        private Builder(ListGroupRepositoriesRequest request) {
            super((Request)request);
            this.groupId = request.groupId;
            this.accessToken = request.accessToken;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.search = request.search;
        }

        public Builder groupId(String groupId) {
            this.putPathParameter("groupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public ListGroupRepositoriesRequest build() {
            return new ListGroupRepositoriesRequest(this);
        }
    }
}

