/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListMergeRequestCommentsRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="commentType")
    private String commentType;
    @Body
    @NameInMap(value="filePath")
    private String filePath;
    @Body
    @NameInMap(value="patchSetBizIds")
    private List<String> patchSetBizIds;
    @Body
    @NameInMap(value="resolved")
    private Boolean resolved;
    @Body
    @NameInMap(value="state")
    private String state;
    @Query
    @NameInMap(value="localId")
    @Validation(required=true)
    private Long localId;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;

    private ListMergeRequestCommentsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.commentType = builder.commentType;
        this.filePath = builder.filePath;
        this.patchSetBizIds = builder.patchSetBizIds;
        this.resolved = builder.resolved;
        this.state = builder.state;
        this.localId = builder.localId;
        this.organizationId = builder.organizationId;
        this.repositoryIdentity = builder.repositoryIdentity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMergeRequestCommentsRequest create() {
        return ListMergeRequestCommentsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getCommentType() {
        return this.commentType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public List<String> getPatchSetBizIds() {
        return this.patchSetBizIds;
    }

    public Boolean getResolved() {
        return this.resolved;
    }

    public String getState() {
        return this.state;
    }

    public Long getLocalId() {
        return this.localId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public static final class Builder
    extends Request.Builder<ListMergeRequestCommentsRequest, Builder> {
        private String accessToken;
        private String commentType;
        private String filePath;
        private List<String> patchSetBizIds;
        private Boolean resolved;
        private String state;
        private Long localId;
        private String organizationId;
        private String repositoryIdentity;

        private Builder() {
        }

        private Builder(ListMergeRequestCommentsRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.commentType = request.commentType;
            this.filePath = request.filePath;
            this.patchSetBizIds = request.patchSetBizIds;
            this.resolved = request.resolved;
            this.state = request.state;
            this.localId = request.localId;
            this.organizationId = request.organizationId;
            this.repositoryIdentity = request.repositoryIdentity;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder commentType(String commentType) {
            this.putBodyParameter("commentType", commentType);
            this.commentType = commentType;
            return this;
        }

        public Builder filePath(String filePath) {
            this.putBodyParameter("filePath", filePath);
            this.filePath = filePath;
            return this;
        }

        public Builder patchSetBizIds(List<String> patchSetBizIds) {
            this.putBodyParameter("patchSetBizIds", patchSetBizIds);
            this.patchSetBizIds = patchSetBizIds;
            return this;
        }

        public Builder resolved(Boolean resolved) {
            this.putBodyParameter("resolved", resolved);
            this.resolved = resolved;
            return this;
        }

        public Builder state(String state) {
            this.putBodyParameter("state", state);
            this.state = state;
            return this;
        }

        public Builder localId(Long localId) {
            this.putQueryParameter("localId", localId);
            this.localId = localId;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public ListMergeRequestCommentsRequest build() {
            return new ListMergeRequestCommentsRequest(this);
        }
    }
}

