/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListProjectLabelsRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Integer page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="repositoryIdentity")
    @Validation(required=true)
    private String repositoryIdentity;
    @Query
    @NameInMap(value="search")
    private String search;
    @Query
    @NameInMap(value="sort")
    private String sort;
    @Query
    @NameInMap(value="withCounts")
    private Boolean withCounts;

    private ListProjectLabelsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.repositoryIdentity = builder.repositoryIdentity;
        this.search = builder.search;
        this.sort = builder.sort;
        this.withCounts = builder.withCounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListProjectLabelsRequest create() {
        return ListProjectLabelsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Integer getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getRepositoryIdentity() {
        return this.repositoryIdentity;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSort() {
        return this.sort;
    }

    public Boolean getWithCounts() {
        return this.withCounts;
    }

    public static final class Builder
    extends Request.Builder<ListProjectLabelsRequest, Builder> {
        private String accessToken;
        private String orderBy;
        private String organizationId;
        private Integer page;
        private Long pageSize;
        private String repositoryIdentity;
        private String search;
        private String sort;
        private Boolean withCounts;

        private Builder() {
        }

        private Builder(ListProjectLabelsRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.repositoryIdentity = request.repositoryIdentity;
            this.search = request.search;
            this.sort = request.sort;
            this.withCounts = request.withCounts;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Integer page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder repositoryIdentity(String repositoryIdentity) {
            this.putQueryParameter("repositoryIdentity", repositoryIdentity);
            this.repositoryIdentity = repositoryIdentity;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public Builder withCounts(Boolean withCounts) {
            this.putQueryParameter("withCounts", withCounts);
            this.withCounts = withCounts;
            return this;
        }

        public ListProjectLabelsRequest build() {
            return new ListProjectLabelsRequest(this);
        }
    }
}

