/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListProjectsRequest
extends Request {
    @Path
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="category")
    @Validation(required=true)
    private String category;
    @Query
    @NameInMap(value="conditions")
    private String conditions;
    @Query
    @NameInMap(value="extraConditions")
    private String extraConditions;
    @Query
    @NameInMap(value="maxResults")
    private Long maxResults;
    @Query
    @NameInMap(value="nextToken")
    private String nextToken;
    @Query
    @NameInMap(value="scope")
    private String scope;

    private ListProjectsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.organizationId = builder.organizationId;
        this.category = builder.category;
        this.conditions = builder.conditions;
        this.extraConditions = builder.extraConditions;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scope = builder.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListProjectsRequest create() {
        return ListProjectsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getConditions() {
        return this.conditions;
    }

    public String getExtraConditions() {
        return this.extraConditions;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getScope() {
        return this.scope;
    }

    public static final class Builder
    extends Request.Builder<ListProjectsRequest, Builder> {
        private String organizationId;
        private String category;
        private String conditions;
        private String extraConditions;
        private Long maxResults;
        private String nextToken;
        private String scope;

        private Builder() {
        }

        private Builder(ListProjectsRequest request) {
            super((Request)request);
            this.organizationId = request.organizationId;
            this.category = request.category;
            this.conditions = request.conditions;
            this.extraConditions = request.extraConditions;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
            this.scope = request.scope;
        }

        public Builder organizationId(String organizationId) {
            this.putPathParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder category(String category) {
            this.putQueryParameter("category", category);
            this.category = category;
            return this;
        }

        public Builder conditions(String conditions) {
            this.putQueryParameter("conditions", conditions);
            this.conditions = conditions;
            return this;
        }

        public Builder extraConditions(String extraConditions) {
            this.putQueryParameter("extraConditions", extraConditions);
            this.extraConditions = extraConditions;
            return this;
        }

        public Builder maxResults(Long maxResults) {
            this.putQueryParameter("maxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("nextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder scope(String scope) {
            this.putQueryParameter("scope", scope);
            this.scope = scope;
            return this;
        }

        public ListProjectsRequest build() {
            return new ListProjectsRequest(this);
        }
    }
}

