/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class ListSearchCommitRequest
extends Request {
    @Body
    @NameInMap(value="keyword")
    @Validation(required=true)
    private String keyword;
    @Body
    @NameInMap(value="order")
    private String order;
    @Body
    @NameInMap(value="page")
    private Integer page;
    @Body
    @NameInMap(value="pageSize")
    private Integer pageSize;
    @Body
    @NameInMap(value="repoPath")
    private RepoPath repoPath;
    @Body
    @NameInMap(value="scope")
    private String scope;
    @Body
    @NameInMap(value="sort")
    private String sort;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private ListSearchCommitRequest(Builder builder) {
        super((Request.Builder)builder);
        this.keyword = builder.keyword;
        this.order = builder.order;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.repoPath = builder.repoPath;
        this.scope = builder.scope;
        this.sort = builder.sort;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSearchCommitRequest create() {
        return ListSearchCommitRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getOrder() {
        return this.order;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSort() {
        return this.sort;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RepoPath
    extends TeaModel {
        @NameInMap(value="matchType")
        private String matchType;
        @NameInMap(value="operatorType")
        private String operatorType;
        @NameInMap(value="value")
        private String value;

        private RepoPath(Builder builder) {
            this.matchType = builder.matchType;
            this.operatorType = builder.operatorType;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RepoPath create() {
            return RepoPath.builder().build();
        }

        public String getMatchType() {
            return this.matchType;
        }

        public String getOperatorType() {
            return this.operatorType;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String matchType;
            private String operatorType;
            private String value;

            public Builder matchType(String matchType) {
                this.matchType = matchType;
                return this;
            }

            public Builder operatorType(String operatorType) {
                this.operatorType = operatorType;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public RepoPath build() {
                return new RepoPath(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ListSearchCommitRequest, Builder> {
        private String keyword;
        private String order;
        private Integer page;
        private Integer pageSize;
        private RepoPath repoPath;
        private String scope;
        private String sort;
        private String organizationId;

        private Builder() {
        }

        private Builder(ListSearchCommitRequest request) {
            super((Request)request);
            this.keyword = request.keyword;
            this.order = request.order;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.repoPath = request.repoPath;
            this.scope = request.scope;
            this.sort = request.sort;
            this.organizationId = request.organizationId;
        }

        public Builder keyword(String keyword) {
            this.putBodyParameter("keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder order(String order) {
            this.putBodyParameter("order", order);
            this.order = order;
            return this;
        }

        public Builder page(Integer page) {
            this.putBodyParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder repoPath(RepoPath repoPath) {
            this.putBodyParameter("repoPath", (Object)repoPath);
            this.repoPath = repoPath;
            return this;
        }

        public Builder scope(String scope) {
            this.putBodyParameter("scope", scope);
            this.scope = scope;
            return this;
        }

        public Builder sort(String sort) {
            this.putBodyParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public ListSearchCommitRequest build() {
            return new ListSearchCommitRequest(this);
        }
    }
}

