/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class MergeMergeRequestRequest
extends Request {
    @Path
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private Long repositoryId;
    @Path
    @NameInMap(value="localId")
    @Validation(required=true)
    private Long localId;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="mergeMessage")
    private String mergeMessage;
    @Body
    @NameInMap(value="mergeType")
    @Validation(required=true)
    private String mergeType;
    @Body
    @NameInMap(value="removeSourceBranch")
    private Boolean removeSourceBranch;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private MergeMergeRequestRequest(Builder builder) {
        super((Request.Builder)builder);
        this.repositoryId = builder.repositoryId;
        this.localId = builder.localId;
        this.accessToken = builder.accessToken;
        this.mergeMessage = builder.mergeMessage;
        this.mergeType = builder.mergeType;
        this.removeSourceBranch = builder.removeSourceBranch;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MergeMergeRequestRequest create() {
        return MergeMergeRequestRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public Long getLocalId() {
        return this.localId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getMergeMessage() {
        return this.mergeMessage;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public Boolean getRemoveSourceBranch() {
        return this.removeSourceBranch;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static final class Builder
    extends Request.Builder<MergeMergeRequestRequest, Builder> {
        private Long repositoryId;
        private Long localId;
        private String accessToken;
        private String mergeMessage;
        private String mergeType;
        private Boolean removeSourceBranch;
        private String organizationId;

        private Builder() {
        }

        private Builder(MergeMergeRequestRequest request) {
            super((Request)request);
            this.repositoryId = request.repositoryId;
            this.localId = request.localId;
            this.accessToken = request.accessToken;
            this.mergeMessage = request.mergeMessage;
            this.mergeType = request.mergeType;
            this.removeSourceBranch = request.removeSourceBranch;
            this.organizationId = request.organizationId;
        }

        public Builder repositoryId(Long repositoryId) {
            this.putPathParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder localId(Long localId) {
            this.putPathParameter("localId", localId);
            this.localId = localId;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder mergeMessage(String mergeMessage) {
            this.putBodyParameter("mergeMessage", mergeMessage);
            this.mergeMessage = mergeMessage;
            return this;
        }

        public Builder mergeType(String mergeType) {
            this.putBodyParameter("mergeType", mergeType);
            this.mergeType = mergeType;
            return this;
        }

        public Builder removeSourceBranch(Boolean removeSourceBranch) {
            this.putBodyParameter("removeSourceBranch", removeSourceBranch);
            this.removeSourceBranch = removeSourceBranch;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public MergeMergeRequestRequest build() {
            return new MergeMergeRequestRequest(this);
        }
    }
}

