/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class TransferRepositoryRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="groupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private String repositoryId;

    private TransferRepositoryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.groupId = builder.groupId;
        this.organizationId = builder.organizationId;
        this.repositoryId = builder.repositoryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransferRepositoryRequest create() {
        return TransferRepositoryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public static final class Builder
    extends Request.Builder<TransferRepositoryRequest, Builder> {
        private String accessToken;
        private String groupId;
        private String organizationId;
        private String repositoryId;

        private Builder() {
        }

        private Builder(TransferRepositoryRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.groupId = request.groupId;
            this.organizationId = request.organizationId;
            this.repositoryId = request.repositoryId;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("groupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.putQueryParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public TransferRepositoryRequest build() {
            return new TransferRepositoryRequest(this);
        }
    }
}

