/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdatePushRuleRequest
extends Request {
    @Path
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private Long repositoryId;
    @Path
    @NameInMap(value="pushRuleId")
    @Validation(required=true)
    private Long pushRuleId;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="ruleInfos")
    private List<RuleInfos> ruleInfos;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private UpdatePushRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.repositoryId = builder.repositoryId;
        this.pushRuleId = builder.pushRuleId;
        this.accessToken = builder.accessToken;
        this.ruleInfos = builder.ruleInfos;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdatePushRuleRequest create() {
        return UpdatePushRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public Long getPushRuleId() {
        return this.pushRuleId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public List<RuleInfos> getRuleInfos() {
        return this.ruleInfos;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RuleInfos
    extends TeaModel {
        @NameInMap(value="checkerName")
        private String checkerName;
        @NameInMap(value="checkerType")
        private String checkerType;
        @NameInMap(value="extraMessage")
        private String extraMessage;
        @NameInMap(value="fileRuleRegexes")
        private List<String> fileRuleRegexes;

        private RuleInfos(Builder builder) {
            this.checkerName = builder.checkerName;
            this.checkerType = builder.checkerType;
            this.extraMessage = builder.extraMessage;
            this.fileRuleRegexes = builder.fileRuleRegexes;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RuleInfos create() {
            return RuleInfos.builder().build();
        }

        public String getCheckerName() {
            return this.checkerName;
        }

        public String getCheckerType() {
            return this.checkerType;
        }

        public String getExtraMessage() {
            return this.extraMessage;
        }

        public List<String> getFileRuleRegexes() {
            return this.fileRuleRegexes;
        }

        public static final class Builder {
            private String checkerName;
            private String checkerType;
            private String extraMessage;
            private List<String> fileRuleRegexes;

            public Builder checkerName(String checkerName) {
                this.checkerName = checkerName;
                return this;
            }

            public Builder checkerType(String checkerType) {
                this.checkerType = checkerType;
                return this;
            }

            public Builder extraMessage(String extraMessage) {
                this.extraMessage = extraMessage;
                return this;
            }

            public Builder fileRuleRegexes(List<String> fileRuleRegexes) {
                this.fileRuleRegexes = fileRuleRegexes;
                return this;
            }

            public RuleInfos build() {
                return new RuleInfos(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdatePushRuleRequest, Builder> {
        private Long repositoryId;
        private Long pushRuleId;
        private String accessToken;
        private List<RuleInfos> ruleInfos;
        private String organizationId;

        private Builder() {
        }

        private Builder(UpdatePushRuleRequest request) {
            super((Request)request);
            this.repositoryId = request.repositoryId;
            this.pushRuleId = request.pushRuleId;
            this.accessToken = request.accessToken;
            this.ruleInfos = request.ruleInfos;
            this.organizationId = request.organizationId;
        }

        public Builder repositoryId(Long repositoryId) {
            this.putPathParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder pushRuleId(Long pushRuleId) {
            this.putPathParameter("pushRuleId", pushRuleId);
            this.pushRuleId = pushRuleId;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder ruleInfos(List<RuleInfos> ruleInfos) {
            this.putBodyParameter("ruleInfos", ruleInfos);
            this.ruleInfos = ruleInfos;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public UpdatePushRuleRequest build() {
            return new UpdatePushRuleRequest(this);
        }
    }
}

