/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateRepositoryMemberRequest
extends Request {
    @Path
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private Long repositoryId;
    @Path
    @NameInMap(value="aliyunPk")
    @Validation(required=true)
    private String aliyunPk;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="accessLevel")
    private Integer accessLevel;
    @Body
    @NameInMap(value="expireAt")
    private String expireAt;
    @Body
    @NameInMap(value="memberType")
    private String memberType;
    @Body
    @NameInMap(value="relatedId")
    private String relatedId;
    @Body
    @NameInMap(value="relatedInfos")
    private List<RelatedInfos> relatedInfos;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private UpdateRepositoryMemberRequest(Builder builder) {
        super((Request.Builder)builder);
        this.repositoryId = builder.repositoryId;
        this.aliyunPk = builder.aliyunPk;
        this.accessToken = builder.accessToken;
        this.accessLevel = builder.accessLevel;
        this.expireAt = builder.expireAt;
        this.memberType = builder.memberType;
        this.relatedId = builder.relatedId;
        this.relatedInfos = builder.relatedInfos;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateRepositoryMemberRequest create() {
        return UpdateRepositoryMemberRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public String getAliyunPk() {
        return this.aliyunPk;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Integer getAccessLevel() {
        return this.accessLevel;
    }

    public String getExpireAt() {
        return this.expireAt;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public String getRelatedId() {
        return this.relatedId;
    }

    public List<RelatedInfos> getRelatedInfos() {
        return this.relatedInfos;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RelatedInfos
    extends TeaModel {
        @NameInMap(value="relatedId")
        private String relatedId;
        @NameInMap(value="sourceId")
        private Long sourceId;
        @NameInMap(value="sourceType")
        private String sourceType;

        private RelatedInfos(Builder builder) {
            this.relatedId = builder.relatedId;
            this.sourceId = builder.sourceId;
            this.sourceType = builder.sourceType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RelatedInfos create() {
            return RelatedInfos.builder().build();
        }

        public String getRelatedId() {
            return this.relatedId;
        }

        public Long getSourceId() {
            return this.sourceId;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public static final class Builder {
            private String relatedId;
            private Long sourceId;
            private String sourceType;

            public Builder relatedId(String relatedId) {
                this.relatedId = relatedId;
                return this;
            }

            public Builder sourceId(Long sourceId) {
                this.sourceId = sourceId;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public RelatedInfos build() {
                return new RelatedInfos(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateRepositoryMemberRequest, Builder> {
        private Long repositoryId;
        private String aliyunPk;
        private String accessToken;
        private Integer accessLevel;
        private String expireAt;
        private String memberType;
        private String relatedId;
        private List<RelatedInfos> relatedInfos;
        private String organizationId;

        private Builder() {
        }

        private Builder(UpdateRepositoryMemberRequest request) {
            super((Request)request);
            this.repositoryId = request.repositoryId;
            this.aliyunPk = request.aliyunPk;
            this.accessToken = request.accessToken;
            this.accessLevel = request.accessLevel;
            this.expireAt = request.expireAt;
            this.memberType = request.memberType;
            this.relatedId = request.relatedId;
            this.relatedInfos = request.relatedInfos;
            this.organizationId = request.organizationId;
        }

        public Builder repositoryId(Long repositoryId) {
            this.putPathParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder aliyunPk(String aliyunPk) {
            this.putPathParameter("aliyunPk", aliyunPk);
            this.aliyunPk = aliyunPk;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder accessLevel(Integer accessLevel) {
            this.putBodyParameter("accessLevel", accessLevel);
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder expireAt(String expireAt) {
            this.putBodyParameter("expireAt", expireAt);
            this.expireAt = expireAt;
            return this;
        }

        public Builder memberType(String memberType) {
            this.putBodyParameter("memberType", memberType);
            this.memberType = memberType;
            return this;
        }

        public Builder relatedId(String relatedId) {
            this.putBodyParameter("relatedId", relatedId);
            this.relatedId = relatedId;
            return this;
        }

        public Builder relatedInfos(List<RelatedInfos> relatedInfos) {
            this.putBodyParameter("relatedInfos", relatedInfos);
            this.relatedInfos = relatedInfos;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public UpdateRepositoryMemberRequest build() {
            return new UpdateRepositoryMemberRequest(this);
        }
    }
}

