/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import com.aliyun.mns.model.TopicMessage;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class Base64TopicMessage
extends TopicMessage {
    @Override
    public void setMessageBody(String messageBody) {
        byte[] bytes;
        try {
            bytes = messageBody.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
        this.setMessageBody(bytes);
    }

    @Override
    public void setMessageBody(byte[] messageBody) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])messageBody);
        this.setBaseMessageBody(encodeBase64);
    }

    @Override
    public String getMessageBody() {
        return this.getMessageBodyAsBase64();
    }

    private String getMessageBodyAsBase64() {
        byte[] bytes = this.getMessageBodyBytes();
        if (bytes == null) {
            return null;
        }
        try {
            return new String(Base64.decodeBase64((byte[])bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

