/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class BaseMessage {
    private String requestId = null;
    private String messageId = null;
    private String messageBodyMD5 = null;
    private byte[] messageBodyBytes = null;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageBodyMD5() {
        return this.messageBodyMD5;
    }

    public void setMessageBodyMD5(String messageBodyMD5) {
        this.messageBodyMD5 = messageBodyMD5;
    }

    protected void setMessageBodyBytes(byte[] messageBodyBytes) {
        this.messageBodyBytes = messageBodyBytes;
    }

    protected byte[] getMessageBodyBytes() {
        return this.messageBodyBytes;
    }

    public void setBaseMessageBody(byte[] messageBody) {
        this.setMessageBodyBytes(messageBody);
    }

    public void setBaseMessageBody(String messageBody) {
        this.setMessageBodyBytes(messageBody.getBytes(Charset.forName("utf-8")));
    }

    public String getOriginalMessageBody() {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        if (messageBodyAsBytes == null) {
            return null;
        }
        try {
            return new String(messageBodyAsBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
    }

    public abstract String getMessageBody();

    public abstract void setMessageBody(String var1);

    public abstract void setMessageBody(byte[] var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.messageId != null) {
            sb.append("MessageID:" + this.messageId + ",");
        }
        if (this.messageBodyMD5 != null) {
            sb.append("MessageMD5:" + this.messageBodyMD5 + ",");
        }
        if (this.requestId != null) {
            sb.append("RequestID:" + this.requestId + ",");
        }
        return sb.toString();
    }
}

