package com.aliyun.mns.client.impl.queue;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.request.queue.BatchPeekMessageRequest;
import com.aliyun.mns.model.serialize.queue.MessageListDeserializer;

import java.net.URI;
import java.util.List;

import static com.aliyun.mns.common.MNSConstants.LOCATION_MESSAGES;

public class BatchPeekMessageAction extends
        AbstractAction<BatchPeekMessageRequest, List<Message>> {

    public BatchPeekMessageAction(ServiceClient client,
                                  ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "BatchPeekMessage", client, credentials, endpoint);

    }

    @Override
    protected RequestMessage buildRequest(BatchPeekMessageRequest reqObject)
            throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        String uri = reqObject.getRequestPath() + "/" + LOCATION_MESSAGES
                + "?peekonly=true&numOfMessages=" + reqObject.getBatchSize();

        requestMessage.setResourcePath(uri);
        return requestMessage;
    }

    @Override
    protected boolean validate(BatchPeekMessageRequest reqObject) {
        if (reqObject.getBatchSize() <= 0) {
            throw new ClientException("BatchSize is invalid");
        }
        return super.validate(reqObject);
    }

    @Override
    protected ResultParser<List<Message>> buildResultParser() {
        return new ResultParser<List<Message>>() {
            public List<Message> parse(ResponseMessage response) throws ResultParseException {
                MessageListDeserializer deserializer = new MessageListDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                } catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:"
                            + e.getMessage(), e);
                }
            }
        };
    }
}
