/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client.impl.queue;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.request.queue.SendMessageRequest;
import com.aliyun.mns.model.serialize.queue.MessageDeserializer;
import com.aliyun.mns.model.serialize.queue.MessageSerializer;
import java.io.InputStream;
import java.net.URI;

public class SendMessageAction
extends AbstractAction<SendMessageRequest, Message> {
    public SendMessageAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.POST, "SendMessage", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(SendMessageRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath() + "/" + "messages");
        MessageSerializer serializer = new MessageSerializer();
        try {
            InputStream is = serializer.serialize(reqObject.getMessage(), "UTF-8");
            requestMessage.setContent(is);
            requestMessage.setContentLength(is.available());
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        return requestMessage;
    }

    @Override
    protected boolean validate(SendMessageRequest request) throws ClientException {
        Message message = request.getMessage();
        if (message == null || message.getMessageBodyAsString() == null) {
            throw new ClientException("MessageBody can not be null");
        }
        return super.validate(request);
    }

    @Override
    protected ResultParser<Message> buildResultParser() {
        return new ResultParser<Message>(){

            @Override
            public Message parse(ResponseMessage response) throws ResultParseException {
                MessageDeserializer deserializer = new MessageDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

