/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.queue;

import com.aliyun.mns.common.BatchSendException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.serialize.XMLDeserializer;
import com.aliyun.mns.model.serialize.queue.MessageListDeserializer;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ErrorMessageListDeserializer
extends XMLDeserializer<Exception> {
    @Override
    public Exception deserialize(InputStream stream) throws Exception {
        Document doc = this.getDocmentBuilder().parse(stream);
        List<Message> msgs = new MessageListDeserializer().deserialize(doc);
        if (msgs != null) {
            return new BatchSendException(msgs);
        }
        Element root = doc.getDocumentElement();
        if (root != null) {
            String code = this.safeGetElementContent(root, "Code", "");
            String message = this.safeGetElementContent(root, "Message", "");
            String requestId = this.safeGetElementContent(root, "RequestId", "");
            String hostId = this.safeGetElementContent(root, "HostId", "");
            return new ServiceException(message, null, code, requestId, hostId);
        }
        return null;
    }
}

