/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsForwardResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsScollResultSet;
import com.aliyun.odps.jdbc.OdpsStaticResultSet;
import com.aliyun.odps.jdbc.PublicMethodAspect;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.OdpsLogger;
import com.aliyun.odps.jdbc.utils.Utils;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OdpsStatement
extends WrapperAdapter
implements Statement {
    private OdpsConnection connHandle;
    private Instance executeInstance = null;
    private ResultSet resultSet = null;
    private int updateCount = -1;
    boolean updateCountFetched = false;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private static final int POLLING_INTERVAL = 3000;
    private static final String JDBC_SQL_TASK_NAME = "jdbc_sql_task";
    private static ResultSet EMPTY_RESULT_SET;
    protected boolean isResultSetScrollable = false;
    private Properties sqlTaskProperties;
    protected FetchDirection resultSetFetchDirection = FetchDirection.UNKNOWN;
    protected int resultSetMaxRows = 0;
    protected int resultSetFetchSize = 10000;
    private SQLWarning warningChain = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;

    static {
        OdpsStatement.ajc$preClinit();
        EMPTY_RESULT_SET = null;
        try {
            OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Collections.singletonList("N/A"), Collections.singletonList(TypeInfoFactory.STRING));
            EMPTY_RESULT_SET = new OdpsStaticResultSet(null, meta, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    OdpsStatement(OdpsConnection conn) {
        this(conn, false);
    }

    OdpsStatement(OdpsConnection conn, boolean isResultSetScrollable) {
        this.connHandle = conn;
        this.sqlTaskProperties = (Properties)conn.getSqlTaskProperties().clone();
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void cancel() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (!this.isCancelled && this.executeInstance != null) {
                try {
                    this.executeInstance.stop();
                    this.connHandle.log.debug("submit cancel to instance id=" + this.executeInstance.getId());
                }
                catch (OdpsException e) {
                    throw new SQLException(e);
                }
                this.isCancelled = true;
            }
            Object var3_3 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var3_3, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.warningChain = null;
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (!this.isClosed) {
                if (this.resultSet != null) {
                    this.resultSet.close();
                    this.resultSet = null;
                }
                this.connHandle.log.debug("the statement has been closed");
                this.connHandle = null;
                this.executeInstance = null;
                this.isClosed = true;
            }
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            ResultSet resultSet;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.beforeExecute();
            this.runSQL(sql);
            ResultSet resultSet2 = this.updateCount < 0 ? this.getResultSet() : EMPTY_RESULT_SET;
            ResultSet resultSet3 = resultSet = resultSet2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(resultSet, joinPoint);
            return resultSet2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        try {
            int n;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.beforeExecute();
            this.runSQL(sql);
            int n2 = this.updateCount >= 0 ? this.updateCount : 0;
            int n3 = n = n2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)nArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (this.processSetClause(sql)) {
                bl2 = bl3 = false;
            } else if (this.processUseClause(sql)) {
                bl2 = bl3 = false;
            } else {
                this.checkClosed();
                this.beforeExecute();
                this.runSQL(sql);
                bl2 = this.updateCount < 0 ? (bl3 = true) : (bl3 = false);
            }
            boolean bl4 = bl = bl2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isQuery(String sql) throws SQLException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string);
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            block7: {
                PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
                BufferedReader reader = new BufferedReader(new StringReader(sql));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.matches("^\\s*(--|#).*") || line.matches("^\\s*$")) continue;
                        if (!line.matches("(?i)^(\\s*)(SELECT).*$")) break;
                        bl2 = bl3 = true;
                        break block7;
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                bl2 = bl3 = false;
            }
            boolean bl4 = bl = bl2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private boolean processSetClause(String sql) {
        if (sql.matches("(?i)^(\\s*)(SET)(\\s+)(.*)=(.*);?(\\s*)$")) {
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            int i = sql.toLowerCase().indexOf("set");
            String pairstring = sql.substring(i + 3);
            String[] pair = pairstring.split("=");
            this.connHandle.log.debug("set sql task property: " + pair[0].trim() + "=" + pair[1].trim());
            this.connHandle.getSqlTaskProperties().setProperty(pair[0].trim(), pair[1].trim());
            this.sqlTaskProperties.setProperty(pair[0].trim(), pair[1].trim());
            return true;
        }
        return false;
    }

    private boolean processUseClause(String sql) {
        if (sql.matches("(?i)^(\\s*)(USE)(\\s+)(.*);?(\\s*)$")) {
            int i;
            String project;
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            if ((project = sql.substring((i = sql.toLowerCase().indexOf("use")) + 3).trim()).length() > 0) {
                this.connHandle.getOdps().setDefaultProject(project);
                this.connHandle.log.debug("set project to " + project);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string, (Object)nArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public OdpsConnection getConnection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        try {
            OdpsConnection odpsConnection;
            OdpsConnection odpsConnection2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            OdpsConnection odpsConnection3 = odpsConnection2 = (odpsConnection = this.connHandle);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(odpsConnection2, joinPoint);
            return odpsConnection;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            int direction;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            switch (this.resultSetFetchDirection) {
                case FORWARD: {
                    direction = 1000;
                    break;
                }
                case REVERSE: {
                    direction = 1001;
                    break;
                }
                default: {
                    direction = 1002;
                }
            }
            int n3 = n2 = (n = direction);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            int n3 = n2 = (n = this.resultSetFetchSize);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        int n = rows;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.resultSetFetchSize = rows;
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n3 = n2 = (n = this.resultSetMaxRows);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        int n = max;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (max < 0) {
                throw new SQLException("max must be >= 0");
            }
            this.resultSetMaxRows = max;
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = false;
            boolean bl3 = bl = false;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        int n = current;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        int n = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        try {
            ResultSet resultSet;
            ResultSet resultSet2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (this.resultSet == null || this.resultSet.isClosed()) {
                InstanceTunnel.DownloadSession session;
                try {
                    InstanceTunnel tunnel = new InstanceTunnel(this.connHandle.getOdps());
                    String te = this.connHandle.getTunnelEndpoint();
                    if (!StringUtils.isNullOrEmpty((String)te)) {
                        this.connHandle.log.info("using tunnel endpoint: " + te);
                        tunnel.setEndpoint(te);
                    }
                    try {
                        session = tunnel.createDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.executeInstance.getId());
                    }
                    catch (TunnelException e1) {
                        this.connHandle.log.info("create download session failed: " + e1.getMessage());
                        this.connHandle.log.info("fallback to limit mode");
                        session = tunnel.createDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.executeInstance.getId(), true);
                    }
                    this.connHandle.log.info("create download session id=" + session.getId());
                }
                catch (TunnelException e) {
                    throw new SQLException("create download session failed: instance id=" + this.executeInstance.getId(), e);
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                ArrayList<TypeInfo> columnSqlTypes = new ArrayList<TypeInfo>();
                for (Column col : session.getSchema().getColumns()) {
                    columnNames.add(col.getName());
                    columnSqlTypes.add(col.getTypeInfo());
                }
                OdpsResultSetMetaData meta = new OdpsResultSetMetaData(columnNames, columnSqlTypes);
                this.resultSet = this.isResultSetScrollable ? new OdpsScollResultSet(this, meta, session) : new OdpsForwardResultSet(this, meta, session);
            }
            ResultSet resultSet3 = resultSet2 = (resultSet = this.resultSet);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(resultSet2, joinPoint);
            return resultSet;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        try {
            int n;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n2 = 1003;
            int n3 = n = 1003;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            int n3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (this.updateCountFetched) {
                n2 = n3 = -1;
            } else {
                this.updateCountFetched = true;
                n2 = this.executeInstance == null ? (n3 = -1) : (n3 = this.updateCount);
            }
            int n4 = n = n2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        try {
            SQLWarning sQLWarning;
            SQLWarning sQLWarning2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            SQLWarning sQLWarning3 = sQLWarning2 = (sQLWarning = this.warningChain);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(sQLWarning2, joinPoint);
            return sQLWarning;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = false;
            boolean bl3 = bl = false;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl3 = bl2 = (bl = this.isClosed);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        try {
            boolean bl;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl2 = false;
            boolean bl3 = bl = false;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        boolean bl = enable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int n = direction;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            switch (direction) {
                case 1000: {
                    this.resultSetFetchDirection = FetchDirection.FORWARD;
                    break;
                }
                case 1001: {
                    this.resultSetFetchDirection = FetchDirection.REVERSE;
                    break;
                }
                case 1002: {
                    this.resultSetFetchDirection = FetchDirection.UNKNOWN;
                    break;
                }
                default: {
                    throw new SQLException("invalid argument for setFetchDirection()");
                }
            }
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        int n = max;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        boolean bl = poolable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private void beforeExecute() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.executeInstance = null;
        this.isClosed = false;
        this.isCancelled = false;
        this.updateCount = -1;
        this.updateCountFetched = false;
    }

    protected OdpsLogger getParentLogger() {
        return this.connHandle.log;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The statement has been closed");
        }
    }

    private void runSQL(String sql) throws SQLException {
        try {
            if (!sql.endsWith(";")) {
                sql = String.valueOf(sql) + ";";
            }
            long begin = System.currentTimeMillis();
            Odps odps = this.connHandle.getOdps();
            HashMap<String, String> settings = new HashMap<String, String>();
            for (String key : this.sqlTaskProperties.stringPropertyNames()) {
                settings.put(key, this.sqlTaskProperties.getProperty(key));
            }
            if (!this.sqlTaskProperties.isEmpty()) {
                this.connHandle.log.debug("Enabled SQL task properties: " + this.sqlTaskProperties);
            }
            this.executeInstance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)sql, (String)JDBC_SQL_TASK_NAME, settings, null);
            LogView logView = new LogView(odps);
            if (this.connHandle.getLogviewHost() != null) {
                logView.setLogViewHost(this.connHandle.getLogviewHost());
            }
            String logViewUrl = logView.generateLogView(this.executeInstance, 168L);
            this.connHandle.log.debug("Run SQL: " + sql);
            this.connHandle.log.info(logViewUrl);
            this.warningChain = new SQLWarning(logViewUrl);
            boolean complete = false;
            while (!complete) {
                Instance.TaskStatus taskstatus;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                try {
                    taskstatus = (Instance.TaskStatus)this.executeInstance.getTaskStatus().get(JDBC_SQL_TASK_NAME);
                    if (taskstatus == null) {
                        this.connHandle.log.warn("NullPointer when get task status");
                        continue;
                    }
                }
                catch (OdpsException e) {
                    this.connHandle.log.error("Fail to get task status:" + sql, e);
                    throw new SQLException("Fail to get task status", e);
                }
                switch (taskstatus.getStatus()) {
                    case SUCCESS: {
                        complete = true;
                        this.connHandle.log.debug("sql status: success");
                        break;
                    }
                    case FAILED: {
                        try {
                            String reason = (String)this.executeInstance.getTaskResults().get(JDBC_SQL_TASK_NAME);
                            this.connHandle.log.error("execute sql [" + sql + "] failed: " + reason);
                            throw new SQLException("execute sql [" + sql + "] failed: " + reason, "FAILED");
                        }
                        catch (OdpsException e) {
                            this.connHandle.log.error("Fail to get task status:" + sql, e);
                            throw new SQLException("Fail to get task status", e);
                        }
                    }
                    case CANCELLED: {
                        this.connHandle.log.info("execute instance cancelled");
                        throw new SQLException("execute instance cancelled", "CANCELLED");
                    }
                    case WAITING: 
                    case RUNNING: 
                    case SUSPENDED: {
                        this.connHandle.log.debug("sql status: " + taskstatus.getStatus());
                    }
                }
            }
            this.executeInstance.waitForSuccess(3000L);
            long end = System.currentTimeMillis();
            this.connHandle.log.debug("It took me " + (end - begin) + " ms to run sql");
            Instance.TaskSummary taskSummary = null;
            try {
                taskSummary = this.executeInstance.getTaskSummary(JDBC_SQL_TASK_NAME);
            }
            catch (OdpsException odpsException) {
                this.connHandle.log.warn("Failed to get TaskSummary: instance_id=" + this.executeInstance.getId() + ", taskname=" + JDBC_SQL_TASK_NAME);
            }
            if (taskSummary != null) {
                this.updateCount = Utils.getSinkCountFromTaskSummary(StringEscapeUtils.unescapeJava((String)taskSummary.getJsonSummary()));
            } else {
                this.connHandle.log.warn("task summary is empty");
            }
            this.connHandle.log.info("successfully updated " + this.updateCount + " records");
        }
        catch (OdpsException e) {
            this.connHandle.log.error("Fail to run sql: " + sql, e);
            throw new SQLException("Fail to run sql:" + sql, e);
        }
    }

    public Instance getExecuteInstance() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        try {
            Instance instance;
            Instance instance2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            Instance instance3 = instance2 = (instance = this.executeInstance);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(instance2, joinPoint);
            return instance;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OdpsStatement.java", OdpsStatement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBatch", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "sql", "java.sql.SQLException", "void"), 111);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancel", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "void"), 116);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "int"), 195);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "int"), 200);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "boolean"), 205);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "sql", "java.sql.SQLException", "boolean"), 210);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isQuery", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "sql", "java.sql.SQLException", "boolean"), 233);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "boolean"), 290);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "boolean"), 295);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "com.aliyun.odps.jdbc.OdpsConnection"), 300);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchDirection", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 305);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchSize", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 323);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearBatch", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "void"), 133);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchSize", "com.aliyun.odps.jdbc.OdpsStatement", "int", "rows", "java.sql.SQLException", "void"), 329);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGeneratedKeys", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 335);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxFieldSize", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 340);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxRows", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 345);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxRows", "com.aliyun.odps.jdbc.OdpsStatement", "int", "max", "java.sql.SQLException", "void"), 350);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMoreResults", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "boolean"), 358);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMoreResults", "com.aliyun.odps.jdbc.OdpsStatement", "int", "current", "java.sql.SQLException", "boolean"), 363);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryTimeout", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 368);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setQueryTimeout", "com.aliyun.odps.jdbc.OdpsStatement", "int", "seconds", "java.sql.SQLException", "void"), 373);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSet", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 378);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "void"), 138);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetConcurrency", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 426);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetHoldability", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 431);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetType", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 436);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getUpdateCount", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "int"), 441);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 454);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCloseOnCompletion", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "boolean"), 458);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "boolean"), 463);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPoolable", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "boolean"), 467);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCursorName", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "name", "java.sql.SQLException", "void"), 472);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEscapeProcessing", "com.aliyun.odps.jdbc.OdpsStatement", "boolean", "enable", "java.sql.SQLException", "void"), 477);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "void"), 143);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchDirection", "com.aliyun.odps.jdbc.OdpsStatement", "int", "direction", "java.sql.SQLException", "void"), 482);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxFieldSize", "com.aliyun.odps.jdbc.OdpsStatement", "int", "max", "java.sql.SQLException", "void"), 500);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPoolable", "com.aliyun.odps.jdbc.OdpsStatement", "boolean", "poolable", "java.sql.SQLException", "void"), 504);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExecuteInstance", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "", "com.aliyun.odps.Instance"), 639);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeOnCompletion", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "void"), 160);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeBatch", "com.aliyun.odps.jdbc.OdpsStatement", "", "", "java.sql.SQLException", "[I"), 165);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "executeQuery", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.ResultSet"), 170);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "executeUpdate", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String", "sql", "java.sql.SQLException", "int"), 180);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.aliyun.odps.jdbc.OdpsStatement", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "int"), 190);
    }

    static enum FetchDirection {
        FORWARD,
        REVERSE,
        UNKNOWN;

    }
}

