/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.jdbc.utils.OdpsLogger;
import java.io.IOException;
import java.net.URISyntaxException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class PublicMethodAspect {
    private OdpsLogger logger = new OdpsLogger(this.getClass().getName(), null, false, null);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ PublicMethodAspect ajc$perSingletonInstance;

    static {
        try {
            PublicMethodAspect.ajc$perSingletonInstance = new PublicMethodAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(public * com.aliyun.odps.jdbc.Odps*.*(..))", argNames="")
    /* synthetic */ void ajc$pointcut$$Include$179() {
    }

    @Before(value="Include()", argNames="")
    public void ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(JoinPoint thisJoinPoint) {
        int lineNumber = this.getCurrentLineNumber(thisJoinPoint);
        String classname = this.getCurrentClassname(thisJoinPoint);
        String methodName = this.getCurrentMethodName(thisJoinPoint);
        String args = this.getCurrentArguments(thisJoinPoint).replaceAll("accessKey=\\w+", "accessKey=***");
        String msg = String.format("Enter: [line %d] [%s] [%s] [%s]", lineNumber, classname, methodName, args);
        this.logger.debug(msg);
    }

    @AfterReturning(pointcut="Include()", returning="ret", argNames="ret")
    public void ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Object ret, JoinPoint thisJoinPoint) {
        int lineNumber = this.getCurrentLineNumber(thisJoinPoint);
        String classname = this.getCurrentClassname(thisJoinPoint);
        String methodName = this.getCurrentMethodName(thisJoinPoint);
        String msg = String.format("Leave: [line %d] [%s] [%s] [%s]", lineNumber, classname, methodName, ret);
        this.logger.debug(msg);
    }

    @AfterThrowing(pointcut="Include()", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(Exception e) {
        this.logger.error("exception happened: ", e);
    }

    private int getCurrentLineNumber(JoinPoint joinPoint) {
        try {
            return joinPoint.getSourceLocation().getLine();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String getCurrentClassname(JoinPoint joinPoint) {
        try {
            return joinPoint.getThis().getClass().getName();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getCurrentMethodName(JoinPoint joinPoint) {
        try {
            return joinPoint.getSignature().getName();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String formatObject(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (o instanceof Object[]) {
            sb.append("[");
            int l = ((Object[])o).length;
            int i = 0;
            while (i < l) {
                Object oi = ((Object[])o)[i];
                sb.append(this.formatObject(oi));
                if (i != l - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
        sb.append("'");
        sb.append(o.toString());
        sb.append("'");
        return sb.toString();
    }

    private String getCurrentArguments(JoinPoint joinPoint) {
        try {
            return this.formatObject(joinPoint.getArgs());
        }
        catch (Exception exception) {
            return "?";
        }
    }

    public static PublicMethodAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com_aliyun_odps_jdbc_PublicMethodAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

