/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcIntTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return 0;
        }
        if (Number.class.isInstance(o)) {
            return ((Number)o).intValue();
        }
        if (o instanceof byte[]) {
            try {
                return Integer.parseInt(ToJdbcIntTransformer.encodeBytes((byte[])o, charset));
            }
            catch (NumberFormatException numberFormatException) {
                String errorMsg = ToJdbcIntTransformer.getTransformationErrMsg(ToJdbcIntTransformer.encodeBytes((byte[])o, charset), Integer.TYPE);
                throw new SQLException(errorMsg);
            }
        }
        String errorMsg = ToJdbcIntTransformer.getInvalidTransformationErrorMsg(o.getClass(), Integer.TYPE);
        throw new SQLException(errorMsg);
    }
}

