/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcLongTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return 0L;
        }
        if (Number.class.isInstance(o)) {
            return ((Number)o).longValue();
        }
        if (o instanceof byte[]) {
            try {
                return Long.parseLong(ToJdbcLongTransformer.encodeBytes((byte[])o, charset));
            }
            catch (NumberFormatException numberFormatException) {
                String errorMsg = ToJdbcLongTransformer.getTransformationErrMsg(ToJdbcLongTransformer.encodeBytes((byte[])o, charset), Long.TYPE);
                throw new SQLException(errorMsg);
            }
        }
        String errorMsg = ToJdbcLongTransformer.getInvalidTransformationErrorMsg(o.getClass(), Long.TYPE);
        throw new SQLException(errorMsg);
    }
}

