/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class StreamJob
extends LazyLoad {
    private String project;
    private StreamJobModel model;
    private RestClient client;

    public StreamJob(StreamJobModel model, String projectName, RestClient client) {
        this.project = projectName;
        this.model = model;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildStreamJobResource(this.project, this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        try {
            this.model = JAXBUtils.unmarshal(resp, StreamJobModel.class);
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + StreamJobModel.class, e);
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getStatus() {
        return this.model.status;
    }

    public int getCPUBind() {
        return Integer.parseInt(this.model.cpuBind);
    }

    public String getOwner() {
        return this.model.owner;
    }

    public int getWorkerNum() {
        return Integer.parseInt(this.model.workerNum);
    }

    public Date getCreateTime() {
        Date date = new Date(Long.parseLong(this.model.createTime) * 1000L);
        return date;
    }

    @XmlRootElement(name="StreamJob")
    static class StreamJobModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Status")
        String status;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="CPUBind")
        String cpuBind;
        @XmlElement(name="WorkerNum")
        String workerNum;
        @XmlElement(name="CreateTime")
        String createTime;
        @XmlElement(name="SQL")
        String sql;

        StreamJobModel() {
        }
    }
}

