/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.StreamClient;
import com.aliyun.odps.tunnel.StreamUploadClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class TableTunnel {
    private Configuration config;

    public TableTunnel(Odps odps) {
        this.config = new Configuration(odps);
    }

    public UploadSession createUploadSession(String projectName, String tableName) throws TunnelException {
        return new UploadSession(projectName, tableName, null, null);
    }

    public UploadSession createUploadSession(String projectName, String tableName, PartitionSpec partitionSpec) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return new UploadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), null);
    }

    public UploadSession getUploadSession(String projectName, String tableName, String id) throws TunnelException {
        return new UploadSession(projectName, tableName, null, id);
    }

    public UploadSession getUploadSession(String projectName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return new UploadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), id);
    }

    public DownloadSession createDownloadSession(String projectName, String tableName) throws TunnelException {
        return new DownloadSession(projectName, tableName, null, null, null);
    }

    public DownloadSession createDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return new DownloadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), null, null);
    }

    public DownloadSession createDownloadSession(String projectName, String tableName, long shardId) throws TunnelException {
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return new DownloadSession(projectName, tableName, null, shardId, null);
    }

    public DownloadSession createDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, long shardId) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return new DownloadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), shardId, null);
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, String id) throws TunnelException {
        return new DownloadSession(projectName, tableName, null, null, id);
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, long shardId, String id) throws TunnelException {
        return new DownloadSession(projectName, tableName, null, shardId, id);
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return new DownloadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), null, id);
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, long shardId, String id) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return new DownloadSession(projectName, tableName, partitionSpec.toString().replaceAll("'", ""), shardId, id);
    }

    public StreamClient createStreamClient(String projectName, String tableName) throws TunnelException {
        return new StreamClient(this.config, projectName, tableName);
    }

    public StreamUploadClient createStreamUploadClient(String projectName, String tableName) throws TunnelException {
        return new StreamUploadClient(this.config, projectName, tableName);
    }

    public void setEndpoint(String endpoint) {
        try {
            URI u = new URI(endpoint);
            this.config.setEndpoint(u);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
    }

    public class DownloadSession {
        private String id;
        private String projectName;
        private String tableName;
        private String partitionSpec;
        private Long shardId;
        private long count;
        private TableSchema schema = new TableSchema();
        private DownloadStatus status = DownloadStatus.UNKNOWN;
        private Configuration conf;
        private RestClient tunnelServiceClient;

        DownloadSession(String projectName, String tableName, String partitionSpec, Long shardId, String downloadId) throws TunnelException {
            this.conf = TableTunnel.this.config;
            this.projectName = projectName;
            this.tableName = tableName;
            this.partitionSpec = partitionSpec;
            this.shardId = shardId;
            this.id = downloadId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            if (this.id == null) {
                this.initiate();
            } else {
                this.reload();
            }
        }

        public TunnelRecordReader openRecordReader(long start, long count) throws TunnelException, IOException {
            return this.openRecordReader(start, count, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress, List<Column> columns) throws TunnelException, IOException {
            CompressOption option = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordReader(start, count, option, columns);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress, List<Column> columns) throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            headers.put("x-odps-tunnel-version", String.valueOf(4));
            switch (compress.algorithm) {
                case ODPS_RAW: {
                    break;
                }
                case ODPS_ZLIB: {
                    headers.put("Accept-Encoding", "deflate");
                    break;
                }
                case ODPS_SNAPPY: {
                    headers.put("Accept-Encoding", "x-snappy-framed");
                    break;
                }
                default: {
                    throw new TunnelException("invalid compression option.");
                }
            }
            if (columns != null && columns.size() != 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < columns.size(); ++i) {
                    sb.append(columns.get(i).getName());
                    if (i == columns.size() - 1) continue;
                    sb.append(",");
                }
                params.put("columns", sb.toString());
            }
            params.put("downloadid", this.id);
            params.put("data", null);
            params.put("rowrange", "(" + start + "," + count + ")");
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            TunnelRecordReader reader = null;
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                Response resp = conn.getResponse();
                if (!resp.isOK()) {
                    TunnelException err = new TunnelException(conn.getInputStream());
                    err.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw err;
                }
                boolean is_compress = false;
                String content_encoding = resp.getHeader("Content-Encoding");
                if (content_encoding != null) {
                    if (content_encoding.equals("deflate")) {
                        this.conf.setCompressOption(new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0));
                    } else if (content_encoding.equals("x-snappy-framed")) {
                        this.conf.setCompressOption(new CompressOption(CompressOption.CompressAlgorithm.ODPS_SNAPPY, -1, 0));
                    } else {
                        throw new TunnelException("invalid content encoding");
                    }
                    is_compress = true;
                }
                CompressOption option = is_compress ? this.conf.getCompressOption() : null;
                reader = new TunnelRecordReader(this.schema, columns, conn, option);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            return reader;
        }

        private void initiate() throws TunnelException {
            block15: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                params.put("downloads", null);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                if (this.shardId != null) {
                    params.put("shard", String.valueOf(this.shardId));
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block15;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void reload() throws TunnelException {
            block15: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                params.put("downloadid", this.id);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                if (this.shardId != null) {
                    params.put("shard", String.valueOf(this.shardId));
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block15;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public long getRecordCount() {
            return this.count;
        }

        public String getId() {
            return this.id;
        }

        public DownloadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        private String getResource() {
            return this.conf.getResource(this.projectName, this.tableName);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = mapper.readTree(is);
                JsonNode node = tree.get("DownloadID");
                if (node != null && !node.isNull()) {
                    this.id = node.asText();
                }
                if ((node = tree.get("Status")) != null && !node.isNull()) {
                    this.status = DownloadStatus.valueOf(node.asText().toUpperCase());
                }
                if ((node = tree.get("RecordCount")) != null && !node.isNull()) {
                    this.count = node.asLong();
                }
                if ((node = tree.get("Schema")) != null && !node.isNull()) {
                    this.schema = new TunnelTableSchema(node);
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum DownloadStatus {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED;

    }

    public class UploadSession {
        private String id;
        private TableSchema schema = new TableSchema();
        private String projectName;
        private String tableName;
        private String partitionSpec;
        private List<Long> blocks = new ArrayList<Long>();
        private UploadStatus status = UploadStatus.UNKNOWN;
        private Configuration conf;
        private RestClient tunnelServiceClient;

        UploadSession(String projectName, String tableName, String partitionSpec, String uploadId) throws TunnelException {
            this.conf = TableTunnel.this.config;
            this.projectName = projectName;
            this.tableName = tableName;
            this.partitionSpec = partitionSpec;
            this.id = uploadId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            if (this.id == null) {
                this.initiate();
            } else {
                this.reload();
            }
        }

        private void initiate() throws TunnelException {
            block14: {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("uploads", null);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block14;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public RecordWriter openRecordWriter(long blockId) throws TunnelException, IOException {
            return this.openRecordWriter(blockId, false);
        }

        public RecordWriter openRecordWriter(long blockId, boolean compress) throws TunnelException, IOException {
            CompressOption option = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordWriter(blockId, option);
        }

        public RecordWriter openRecordWriter(long blockId, CompressOption compress) throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Transfer-Encoding", "chunked");
            headers.put("Content-Type", "application/octet-stream");
            headers.put("x-odps-tunnel-version", String.valueOf(4));
            switch (compress.algorithm) {
                case ODPS_RAW: {
                    break;
                }
                case ODPS_ZLIB: {
                    headers.put("Content-Encoding", "deflate");
                    break;
                }
                case ODPS_SNAPPY: {
                    headers.put("Content-Encoding", "x-snappy-framed");
                    break;
                }
                default: {
                    throw new TunnelException("invalid compression option.");
                }
            }
            params.put("uploadid", this.id);
            params.put("blockid", Long.toString(blockId));
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            TunnelRecordWriter writer = null;
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "PUT", params, headers);
                writer = new TunnelRecordWriter(this.schema, conn, compress);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e.getCause());
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            return writer;
        }

        private void reload() throws TunnelException {
            block14: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                params.put("uploadid", this.id);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block14;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public void commit(Long[] blocks) throws TunnelException, IOException {
            if (blocks == null) {
                throw new IllegalArgumentException("Invalid argument: blocks.");
            }
            HashMap<Long, Boolean> clientBlockMap = new HashMap<Long, Boolean>();
            for (Long blockId : blocks) {
                clientBlockMap.put(blockId, true);
            }
            Long[] serverBlocks = this.getBlockList();
            HashMap<Long, Boolean> serverBlockMap = new HashMap<Long, Boolean>();
            for (Long blockId : serverBlocks) {
                serverBlockMap.put(blockId, true);
            }
            if (serverBlockMap.size() != clientBlockMap.size()) {
                throw new TunnelException("Blocks not match, server: " + serverBlockMap.size() + ", tunnelServiceClient: " + clientBlockMap.size());
            }
            for (Long blockId : blocks) {
                if (serverBlockMap.containsKey(blockId)) continue;
                throw new TunnelException("Block not exsits on server, block id is " + blockId);
            }
            this.completeUpload();
        }

        private void completeUpload() throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            params.put("uploadid", this.id);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            int count = 0;
            while (true) {
                ++count;
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break;
                    }
                    if (resp.getStatus() == 500 && count < 3) {
                        try {
                            Thread.sleep(2 * count * 1000);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new TunnelException(e.getMessage(), e);
                        }
                    }
                    try {
                        throw new TunnelException(conn.getInputStream());
                    }
                    catch (IOException e) {
                        throw new TunnelException(e.getMessage(), e);
                    }
                    catch (TunnelException e) {
                        throw e;
                    }
                    catch (OdpsException e) {
                        throw new TunnelException(e.getMessage(), e);
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.disconnect();
                    continue;
                }
                break;
            }
        }

        public String getId() {
            return this.id;
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public UploadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        public Record newRecord() {
            return new ArrayRecord(this.getSchema().getColumns().toArray(new Column[0]));
        }

        public Long[] getBlockList() throws TunnelException, IOException {
            this.reload();
            return this.blocks.toArray(new Long[0]);
        }

        private String getResource() {
            return this.conf.getResource(this.projectName, this.tableName);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = mapper.readTree(is);
                JsonNode node = tree.get("UploadID");
                if (node != null && !node.isNull()) {
                    this.id = node.asText();
                }
                if ((node = tree.get("Status")) != null && !node.isNull()) {
                    this.status = UploadStatus.valueOf(node.asText().toUpperCase());
                }
                this.blocks.clear();
                node = tree.get("UploadedBlockList");
                if (node != null && !node.isNull() && node.isArray()) {
                    Iterator it = node.getElements();
                    while (it.hasNext()) {
                        this.blocks.add(((JsonNode)it.next()).get("BlockID").asLong());
                    }
                }
                if ((node = tree.get("Schema")) != null && !node.isNull()) {
                    this.schema = new TunnelTableSchema(node);
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum UploadStatus {
        UNKNOWN,
        NORMAL,
        CLOSING,
        CLOSED,
        CANCELED,
        EXPIRED,
        CRITICAL;

    }
}

