/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.SnappyFramedInputStream;

class ProtobufRecordStreamReader
implements RecordReader {
    private BufferedInputStream bin;
    private CodedInputStream in;
    private Column[] columns;
    private long count;
    private long bytesReaded = 0L;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in, CompressOption option) throws IOException {
        this(schema, null, in, option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamReader(TableSchema schema, List<Column> columns, InputStream in, CompressOption option) throws IOException {
        if (columns == null) {
            this.columns = schema.getColumns().toArray(new Column[0]);
        } else {
            Column[] tmpColumns = new Column[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                tmpColumns[i] = schema.getColumn(columns.get(i).getName());
            }
            this.columns = tmpColumns;
        }
        this.bin = new BufferedInputStream(in);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = CodedInputStream.newInstance((InputStream)new InflaterInputStream(this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = CodedInputStream.newInstance((InputStream)new SnappyFramedInputStream((InputStream)this.bin));
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.in = CodedInputStream.newInstance((InputStream)this.bin);
            }
        } else {
            this.in = CodedInputStream.newInstance((InputStream)this.bin);
        }
        this.in.setSizeLimit(Integer.MAX_VALUE);
    }

    public Record read(Record reuseRecord) throws IOException {
        int checkSum;
        block21: {
            int i;
            if (reuseRecord == null) {
                reuseRecord = new ArrayRecord(this.columns);
            } else {
                for (int i2 = 0; i2 < reuseRecord.getColumnCount(); ++i2) {
                    reuseRecord.set(i2, null);
                }
            }
            block9: while (true) {
                checkSum = 0;
                if (this.in.isAtEnd()) {
                    throw new IOException("No more record");
                }
                i = ProtobufRecordStreamReader.getTagFieldNumber(this.in);
                if (i == 33553408) {
                    checkSum = (int)this.crc.getValue();
                    if (this.in.readUInt32() != checkSum) {
                        throw new IOException("Checksum invalid.");
                    }
                    break block21;
                }
                if (i == 0x1FFFFFE) {
                    if (this.count != this.in.readSInt64()) {
                        throw new IOException("count does not match.");
                    }
                    if (0x1FFFFFF != ProtobufRecordStreamReader.getTagFieldNumber(this.in)) {
                        throw new IOException("Invalid stream.");
                    }
                    if ((int)this.crccrc.getValue() != this.in.readUInt32()) {
                        throw new IOException("Checksum invalid.");
                    }
                    if (!this.in.isAtEnd()) {
                        throw new IOException("Expect at the end of stream, but not.");
                    }
                    return null;
                }
                if (i > this.columns.length) {
                    throw new IOException("Invalid protobuf tag. Perhaps the datastream from server is crushed.");
                }
                this.crc.update(i);
                switch (this.columns[i - 1].getType()) {
                    case DOUBLE: {
                        double v = this.in.readDouble();
                        this.crc.update(v);
                        reuseRecord.setDouble(i - 1, Double.valueOf(v));
                        continue block9;
                    }
                    case BOOLEAN: {
                        boolean v = this.in.readBool();
                        this.crc.update(v);
                        reuseRecord.setBoolean(i - 1, Boolean.valueOf(v));
                        continue block9;
                    }
                    case BIGINT: {
                        long v = this.in.readSInt64();
                        this.crc.update(v);
                        reuseRecord.setBigint(i - 1, Long.valueOf(v));
                        continue block9;
                    }
                    case STRING: {
                        int size = this.in.readRawVarint32();
                        byte[] bytes = this.in.readRawBytes(size);
                        this.crc.update(bytes, 0, bytes.length);
                        reuseRecord.setString(i - 1, bytes);
                        this.bytesReaded += (long)this.in.getTotalBytesRead();
                        this.in.resetSizeCounter();
                        continue block9;
                    }
                    case DATETIME: {
                        long v = this.in.readSInt64();
                        this.crc.update(v);
                        reuseRecord.setDatetime(i - 1, DateUtils.ms2date(v));
                        continue block9;
                    }
                    case DECIMAL: {
                        int size = this.in.readRawVarint32();
                        byte[] bytes = this.in.readRawBytes(size);
                        this.crc.update(bytes, 0, bytes.length);
                        BigDecimal decimal = new BigDecimal(new String(bytes, "UTF-8"));
                        reuseRecord.setDecimal(i - 1, decimal);
                        continue block9;
                    }
                }
                break;
            }
            throw new IOException("Unsupported type " + this.columns[i - 1].getType());
        }
        this.crc.reset();
        this.crccrc.update(checkSum);
        this.bytesReaded += (long)this.in.getTotalBytesRead();
        this.in.resetSizeCounter();
        ++this.count;
        return reuseRecord;
    }

    static int getTagFieldNumber(CodedInputStream in) throws IOException {
        return WireFormat.getTagFieldNumber((int)in.readTag());
    }

    @Override
    public Record read() throws IOException {
        return this.read(null);
    }

    public Record createEmptyRecord() throws IOException {
        return new ArrayRecord(this.columns);
    }

    @Override
    public void close() throws IOException {
        if (this.bin != null) {
            this.bin.close();
        }
    }

    public long getTotalBytes() {
        return this.bytesReaded;
    }
}

