/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.StreamRecordPack;
import com.aliyun.odps.tunnel.io.proto.XstreamPack;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class StreamUploadWriter {
    private RestClient tunnelServiceClient;
    private String path;
    private MessageDigest messageDigest;
    private HashMap<String, String> params;
    private HashMap<String, String> headers;

    public StreamUploadWriter(RestClient tunnelServiceClient, String path, HashMap<String, String> params, HashMap<String, String> headers) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.path = path;
        this.params = params;
        this.headers = headers;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void write(StreamRecordPack recordPack) throws TunnelException, IOException {
        this.write(null, recordPack);
    }

    public void write(PartitionSpec partitionSpec, StreamRecordPack recordPack) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Encoding", "deflate");
        try {
            byte[] bytes = recordPack.getByteArray();
            XstreamPack.XStreamPack.Builder pack = XstreamPack.XStreamPack.newBuilder();
            pack.setPackData(ByteString.copyFrom((byte[])bytes));
            bytes = pack.build().toByteArray();
            if (null != partitionSpec && partitionSpec.toString().length() > 0) {
                params.put("partition", partitionSpec.toString().replace("'", ""));
            }
            params.put("recordcount", String.valueOf(recordPack.getRecordCount()));
            headers.put("Content-MD5", this.generateMD5(bytes));
            Response resp = this.tunnelServiceClient.requestForRawResponse(this.path, "PUT", params, headers, new ByteArrayInputStream(bytes), bytes.length);
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(new ByteArrayInputStream(resp.getBody()));
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    private String generateMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

