/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.proto;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamWriter$AjcClosure1;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xerial.snappy.SnappyFramedOutputStream;

public class ProtobufRecordStreamWriter
implements RecordWriter {
    private CountingOutputStream bou;
    private Column[] columns;
    private CodedOutputStream out;
    private long count;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();
    private Deflater def;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out) throws IOException {
        this(schema, out, new CompressOption());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out, CompressOption option) throws IOException {
        OutputStream tmpOut;
        this.columns = schema.getColumns().toArray(new Column[0]);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.def = new Deflater();
                this.def.setLevel(option.level);
                this.def.setStrategy(option.strategy);
                tmpOut = new DeflaterOutputStream(out, this.def);
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                tmpOut = new SnappyFramedOutputStream(out);
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                tmpOut = out;
            }
        } else {
            tmpOut = out;
        }
        this.bou = new CountingOutputStream(tmpOut);
        this.out = CodedOutputStream.newInstance((OutputStream)this.bou);
    }

    static void writeRawBytes(int fieldNumber, byte[] value, CodedOutputStream out) throws IOException {
        out.writeTag(fieldNumber, 2);
        out.writeRawVarint32(value.length);
        out.writeRawBytes(value);
    }

    @Override
    public void write(Record r) throws IOException {
        int columnCount;
        int recordValues = r.getColumnCount();
        if (recordValues > (columnCount = this.columns.length)) {
            throw new IOException("record values more than schema.");
        }
        block10: for (int i = 0; i < columnCount && i < recordValues; ++i) {
            Object v = r.get(i);
            if (v == null) continue;
            int pbIdx = i + 1;
            this.crc.update(pbIdx);
            OdpsType type = this.columns[i].getType();
            switch (type) {
                case BOOLEAN: {
                    boolean value = (Boolean)v;
                    this.crc.update(value);
                    this.out.writeBool(pbIdx, value);
                    continue block10;
                }
                case DATETIME: {
                    Date value = (Date)v;
                    Long longValue = DateUtils.date2ms(value);
                    this.crc.update(longValue);
                    this.out.writeSInt64(pbIdx, longValue.longValue());
                    continue block10;
                }
                case STRING: {
                    byte[] bytes;
                    if (v instanceof String) {
                        String value = (String)v;
                        bytes = value.getBytes("UTF-8");
                    } else {
                        bytes = (byte[])v;
                    }
                    this.crc.update(bytes, 0, bytes.length);
                    ProtobufRecordStreamWriter.writeRawBytes(pbIdx, bytes, this.out);
                    continue block10;
                }
                case DOUBLE: {
                    double value = (Double)v;
                    this.crc.update(value);
                    this.out.writeDouble(pbIdx, value);
                    continue block10;
                }
                case BIGINT: {
                    long value = (Long)v;
                    this.crc.update(value);
                    this.out.writeSInt64(pbIdx, value);
                    continue block10;
                }
                case DECIMAL: {
                    String value = ((BigDecimal)v).toPlainString();
                    byte[] bytes = value.getBytes("UTF-8");
                    this.crc.update(bytes, 0, bytes.length);
                    ProtobufRecordStreamWriter.writeRawBytes(pbIdx, bytes, this.out);
                    continue block10;
                }
                case ARRAY: {
                    List genericTypeList = this.columns[i].getGenericTypeList();
                    if (genericTypeList == null || genericTypeList.isEmpty()) {
                        throw new IOException("Failed to get OdpsType inside Array of column index: " + i);
                    }
                    this.out.writeTag(pbIdx, 2);
                    this.writeArray((List)v, (OdpsType)genericTypeList.get(0));
                    continue block10;
                }
                case MAP: {
                    List genericTypeList = this.columns[i].getGenericTypeList();
                    if (genericTypeList == null || genericTypeList.isEmpty() || genericTypeList.size() < 2) {
                        throw new IOException("Failed to get OdpsType inside Map of column index: " + i);
                    }
                    this.out.writeTag(pbIdx, 2);
                    this.writeMap((Map)v, (OdpsType)genericTypeList.get(0), (OdpsType)genericTypeList.get(1));
                    continue block10;
                }
                default: {
                    throw new IOException("Invalid data type: " + type);
                }
            }
        }
        int checksum = (int)this.crc.getValue();
        this.out.writeUInt32(33553408, checksum);
        this.crc.reset();
        this.crccrc.update(checksum);
        ++this.count;
    }

    private void writeArray(List v, OdpsType type) throws IOException {
        this.out.writeInt32NoTag(v.size());
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == null) {
                this.out.writeBoolNoTag(true);
                continue;
            }
            this.out.writeBoolNoTag(false);
            this.writePrimitiveObject(v.get(i), type);
        }
    }

    private void writeMap(Map v, OdpsType keyType, OdpsType valueType) throws IOException {
        if (keyType == OdpsType.BOOLEAN || keyType == OdpsType.DOUBLE) {
            throw new IOException(keyType + " is not supported as key in MAP");
        }
        if (valueType == OdpsType.BOOLEAN) {
            throw new IOException(valueType + "is not supported as value in MAP");
        }
        ArrayList keyList = new ArrayList();
        ArrayList valueList = new ArrayList();
        for (Map.Entry entry : v.entrySet()) {
            if (entry.getKey() == null) {
                throw new IOException("SQLMap's key can't be null.");
            }
            keyList.add(entry.getKey());
            valueList.add(entry.getValue());
        }
        this.writeArray(keyList, keyType);
        this.writeArray(valueList, valueType);
    }

    private void writePrimitiveObject(Object v, OdpsType type) throws IOException {
        switch (type) {
            case STRING: {
                byte[] bytes;
                if (v instanceof String) {
                    String value = (String)v;
                    bytes = value.getBytes();
                } else {
                    bytes = (byte[])v;
                }
                this.out.writeRawVarint32(bytes.length);
                this.out.writeRawBytes(bytes);
                this.crc.update(bytes, 0, bytes.length);
                break;
            }
            case BIGINT: {
                long value = (Long)v;
                this.out.writeSInt64NoTag(value);
                this.crc.update(value);
                break;
            }
            case DOUBLE: {
                double value = (Double)v;
                this.out.writeDoubleNoTag(value);
                this.crc.update(value);
                break;
            }
            case BOOLEAN: {
                boolean value = (Boolean)v;
                this.out.writeBoolNoTag(value);
                this.crc.update(value);
                break;
            }
            default: {
                throw new IOException("Not a primitive type in array. type :" + type);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.writeSInt64(0x1FFFFFE, this.count);
            this.out.writeUInt32(0x1FFFFFF, (int)this.crccrc.getValue());
            this.out.flush();
            this.bou.close();
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
        }
    }

    public long getTotalBytes() {
        return this.bou.getByteCount();
    }

    @Deprecated
    public void write(RecordPack pack) throws IOException {
        RecordPack recordPack = pack;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)recordPack);
        Object[] objectArray = new Object[]{this, recordPack, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new ProtobufRecordStreamWriter$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Checksum getCheckSum() {
        return this.crccrc;
    }

    public void setCheckSum(Checksum checkSum) {
        this.crccrc = checkSum;
    }

    static {
        ProtobufRecordStreamWriter.ajc$preClinit();
    }

    static /* synthetic */ void write_aroundBody0(ProtobufRecordStreamWriter ajc$this, RecordPack pack, JoinPoint joinPoint) {
        if (pack instanceof ProtobufRecordPack) {
            ProtobufRecordPack pbPack = (ProtobufRecordPack)pack;
            pbPack.getProtobufStream().writeTo((OutputStream)ajc$this.bou);
            ajc$this.count += pbPack.getSize();
            ajc$this.setCheckSum(pbPack.getCheckSum());
        } else {
            Record record;
            RecordReader reader = pack.getRecordReader();
            while ((record = reader.read()) != null) {
                ajc$this.write(record);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProtobufRecordStreamWriter.java", ProtobufRecordStreamWriter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "write", "com.aliyun.odps.commons.proto.ProtobufRecordStreamWriter", "com.aliyun.odps.data.RecordPack", "pack", "java.io.IOException", "void"), 307);
    }
}

