/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import java.util.Arrays;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;

class TunnelTableSchema
extends TableSchema {
    public TunnelTableSchema(JsonNode node) {
        JsonNode columns = node.get("columns");
        if (columns.isArray()) {
            Iterator it = columns.getElements();
            while (it.hasNext()) {
                JsonNode column = (JsonNode)it.next();
                JsonNode name = column.get("name");
                JsonNode type = column.get("type");
                Column col = null;
                if (type.asText().toUpperCase().startsWith("MAP")) {
                    col = new Column(name.asText(), OdpsType.MAP);
                    col.setGenericTypeList(Arrays.asList(this.parseMapType(type.asText().toUpperCase())));
                } else if (type.asText().toUpperCase().startsWith("ARRAY")) {
                    col = new Column(name.asText(), OdpsType.ARRAY);
                    col.setGenericTypeList(Arrays.asList(this.parseArrayType(type.asText().toUpperCase())));
                } else {
                    col = new Column(name.asText(), OdpsType.valueOf((String)type.asText().toUpperCase()));
                }
                this.addColumn(col);
            }
        }
    }

    private OdpsType parseArrayType(String typeLiteral) throws IllegalArgumentException {
        if (!typeLiteral.startsWith("ARRAY<")) {
            throw new IllegalArgumentException("Array type should start with ARRAY<, now is " + typeLiteral);
        }
        String subTypeLiteral = typeLiteral.substring("ARRAY<".length(), typeLiteral.length() - 1);
        OdpsType type = OdpsType.valueOf((String)subTypeLiteral);
        return type;
    }

    private OdpsType[] parseMapType(String typeLiteral) throws IllegalArgumentException {
        if (!typeLiteral.startsWith("MAP<")) {
            throw new IllegalArgumentException("Map type should start with Map<, now is " + typeLiteral);
        }
        String subTypeLiteral = typeLiteral.substring("Map<".length(), typeLiteral.length() - 1);
        String[] subTypes = subTypeLiteral.split(",");
        if (subTypes.length != 2) {
            throw new IllegalArgumentException("Map type's format is Map<keyType,valueType> , now is " + typeLiteral);
        }
        OdpsType[] types = new OdpsType[]{OdpsType.valueOf((String)subTypes[0]), OdpsType.valueOf((String)subTypes[1])};
        return types;
    }
}

