/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Table;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Partition
extends LazyLoad {
    private PartitionModel model;
    private PartitionSpec spec;
    private String project;
    private String table;
    private RestClient client;
    private long size;
    private boolean isExtendInfoLoaded;
    private boolean isArchived;
    private boolean isExstore;
    private long lifeCycle;
    private long physicalSize;
    private long fileNum;
    private String reserved;
    private Table.ClusterInfo clusterInfo;

    Partition(PartitionModel model, String projectName, String tableName, RestClient client) {
        this.model = model;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
    }

    Partition(PartitionSpec spec, String projectName, String tableName, RestClient client) {
        this.spec = spec;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
        this.model = new PartitionModel();
    }

    public PartitionSpec getPartitionSpec() {
        if (this.spec != null) {
            return this.spec;
        }
        this.spec = new PartitionSpec();
        for (ColumnModel c : this.model.columns) {
            this.spec.set(c.columnName, c.columnValue);
        }
        return this.spec;
    }

    public Date getCreatedTime() {
        if (this.model == null || this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model == null || this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public Date getLastDataModifiedTime() {
        if (this.model == null || this.model.lastDataModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastDataModifiedTime;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.isArchived;
    }

    public boolean isExstore() {
        this.lazyLoadExtendInfo();
        return this.isExstore;
    }

    public long getLifeCycle() {
        this.lazyLoadExtendInfo();
        return this.lifeCycle;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.fileNum;
    }

    public long getSize() {
        this.lazyLoad();
        return this.size;
    }

    public String getReserved() {
        if (this.reserved == null) {
            this.lazyLoadExtendInfo();
        }
        return this.reserved;
    }

    public Table.ClusterInfo getClusterInfo() {
        if (this.clusterInfo == null) {
            this.lazyLoadExtendInfo();
        }
        return this.clusterInfo;
    }

    @Override
    public void reload() throws OdpsException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partition", this.getPartitionSpec().toString());
        String resource = ResourceBuilder.buildTableResource(this.project, this.table);
        PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
        try {
            JSONObject tree = JSON.parseObject((String)meta.schema);
            Long node = tree.getLong("createTime");
            if (node != null) {
                this.model.createdTime = new Date(node * 1000L);
            }
            if ((node = tree.getLong("lastDDLTime")) != null) {
                this.model.lastMetaModifiedTime = new Date(node * 1000L);
            }
            if ((node = tree.getLong("lastModifiedTime")) != null) {
                this.model.lastDataModifiedTime = new Date(node * 1000L);
            }
            if ((node = tree.getLong("partitionSize")) != null) {
                this.size = node;
            }
            this.setLoaded(true);
        }
        catch (Exception e) {
            throw new OdpsException("Invalid partition meta", e);
        }
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("extended", null);
            params.put("partition", this.getPartitionSpec().toString());
            String resource = ResourceBuilder.buildTableResource(this.project, this.table);
            try {
                String node3;
                Long node2;
                PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
                JSONObject tree = JSON.parseObject((String)meta.schema);
                Boolean node = tree.getBoolean("IsArchived");
                if (node != null) {
                    this.isArchived = node;
                }
                if ((node = tree.getBoolean("IsExstore")) != null) {
                    this.isExstore = node;
                }
                if ((node2 = tree.getLong("LifeCycle")) != null) {
                    this.lifeCycle = node2;
                }
                if ((node2 = tree.getLong("PhysicalSize")) != null) {
                    this.physicalSize = node2;
                }
                if ((node2 = tree.getLong("FileNum")) != null) {
                    this.fileNum = node2;
                }
                if ((node3 = tree.getString("Reserved")) != null) {
                    this.reserved = node3;
                    this.loadReservedJson(node3);
                }
            }
            catch (Exception e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.isExtendInfoLoaded = true;
        }
    }

    private void loadReservedJson(String reserved) {
        JSONObject reservedJson = JSON.parseObject((String)reserved);
        this.clusterInfo = Table.parseClusterInfo(reservedJson);
    }

    @XmlRootElement(name="Partition")
    private static class PartitionMeta {
        @XmlElement(name="Schema")
        private String schema;

        private PartitionMeta() {
        }
    }

    static class EpochBinding
    extends JAXBUtils.DateBinding {
        EpochBinding() {
        }

        @Override
        public Date unmarshal(String v) {
            try {
                return new Date(Long.parseLong(v) * 1000L);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @XmlRootElement(name="Column")
    static class ColumnModel {
        @XmlAttribute(name="Name")
        private String columnName;
        @XmlAttribute(name="Value")
        private String columnValue;

        ColumnModel() {
        }
    }

    @XmlRootElement(name="Partition")
    static class PartitionModel {
        @XmlElement(name="Column")
        private List<ColumnModel> columns = new ArrayList<ColumnModel>();
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=EpochBinding.class)
        Date createdTime;
        @XmlElement(name="LastDDLTime")
        @XmlJavaTypeAdapter(value=EpochBinding.class)
        Date lastMetaModifiedTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=EpochBinding.class)
        Date lastDataModifiedTime;

        PartitionModel() {
        }
    }
}

