/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.alibaba.fastjson.JSON;
import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.StreamJob;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.GalaxyTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class StreamJobs
implements Iterable<StreamJob> {
    RestClient client;
    Odps odps;

    public StreamJobs(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    @Override
    public Iterator<StreamJob> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<StreamJob> iterator(final String projectName) {
        return new ListIterator<StreamJob>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<StreamJob> list() {
                ArrayList<StreamJob> streamJobs = new ArrayList<StreamJob>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && (lastMarker == null || lastMarker.length() == 0)) {
                    return null;
                }
                String resource = ResourceBuilder.buildStreamJobsResource(projectName);
                try {
                    ListStreamJobsResponse resp = StreamJobs.this.client.request(ListStreamJobsResponse.class, resource, "GET", this.params);
                    for (StreamJob.StreamJobModel model : resp.streamJobs) {
                        StreamJob t = new StreamJob(model, projectName, StreamJobs.this.client);
                        streamJobs.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return streamJobs;
            }
        };
    }

    public String create(String streamJobName, String sql, Map<String, String> hints) throws OdpsException {
        return this.create(this.getDefaultProjectName(), streamJobName, sql, hints);
    }

    public String create(String projectName, String streamJobName, String sql, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        if (sql.length() == 0) {
            throw new OdpsException("Sql can not be empty");
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("CREATE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("CREATE_STREAMJOB");
        task.setSql(sql);
        if (hints != null) {
            try {
                String json = JSON.toJSONString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    public String delete(String streamJobName) throws OdpsException {
        return this.delete(this.getDefaultProjectName(), streamJobName);
    }

    public String delete(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("DELETE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("DELETE_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String getStatus(String streamJobName) throws OdpsException {
        return this.getStatus(this.getDefaultProjectName(), streamJobName);
    }

    public String getStatus(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("GETSTATUS_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("STATUS_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String pause(String streamJobName) throws OdpsException {
        return this.pause(this.getDefaultProjectName(), streamJobName);
    }

    public String pause(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("PAUSE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("PAUSE_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String resume(String streamJobName, Map<String, String> hints) throws OdpsException {
        return this.resume(this.getDefaultProjectName(), streamJobName, hints);
    }

    public String resume(String projectName, String streamJobName, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("RESUME_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("RESUME_STREAMJOB");
        if (hints != null) {
            try {
                String json = JSON.toJSONString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    public String rebalance(String streamJobName, Map<String, String> hints) throws OdpsException {
        return this.rebalance(this.getDefaultProjectName(), streamJobName, hints);
    }

    public String rebalance(String projectName, String streamJobName, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("REBALANCE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("REBALANCE_STREAMJOB");
        if (hints != null) {
            try {
                String json = JSON.toJSONString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private String runInstance(String projectName, GalaxyTask task) throws OdpsException {
        Instance instance = this.odps.instances().create(projectName, task);
        instance.waitForSuccess();
        Map<String, String> resultMap = instance.getTaskResults();
        return resultMap.get(task.getName());
    }

    @XmlRootElement(name="StreamJobs")
    private static class ListStreamJobsResponse {
        @XmlElement(name="StreamJob")
        private List<StreamJob.StreamJobModel> streamJobs = new ArrayList<StreamJob.StreamJobModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListStreamJobsResponse() {
        }
    }
}

