/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.VolumeFilter;
import com.aliyun.odps.Volumes$AjcClosure1;
import com.aliyun.odps.Volumes$AjcClosure3;
import com.aliyun.odps.Volumes$AjcClosure5;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class Volumes
implements Iterable<Volume> {
    private RestClient client;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    Volumes(RestClient client) {
        this.client = client;
    }

    public Volume get(String volumeName) {
        return this.get(this.getDefaultProjectName(), volumeName);
    }

    public Volume get(String projectName, String volumeName) {
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        Volume t = new Volume(model, projectName, this.client);
        return t;
    }

    public boolean exists(String volumeName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), volumeName);
    }

    public boolean exists(String projectName, String volumeName) throws OdpsException {
        try {
            Volume v = this.get(projectName, volumeName);
            v.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Volume> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Volume> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Volume> iterator(VolumeFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Volume> iterator(final String projectName, final VolumeFilter filter) {
        return new ListIterator<Volume>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Volume> list() {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ResourceBuilder.buildVolumesResource(projectName);
                try {
                    ListVolumesResponse resp = Volumes.this.client.request(ListVolumesResponse.class, resource, "GET", this.params);
                    for (Volume.VolumeModel model : resp.volumes) {
                        Volume t = new Volume(model, projectName, Volumes.this.client);
                        volumes.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return volumes;
            }
        };
    }

    @Deprecated
    public void create(String volumeName, String comment) throws OdpsException {
        String string = volumeName;
        String string2 = comment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new Volumes$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    public void create(String projectName, String volumeName, String comment) throws OdpsException {
        String string = projectName;
        String string2 = volumeName;
        String string3 = comment;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new Volumes$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public void create(String volumeName, String comment, Volume.Type type) throws OdpsException {
        this.create(this.client.getDefaultProject(), volumeName, comment, type);
    }

    public void create(String projectName, String volumeName, String comment, Volume.Type type) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        if (type != null) {
            model.type = type.name().toLowerCase();
        }
        String xml = null;
        try {
            xml = JAXBUtils.marshal(model, Volume.VolumeModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void delete(String volumeName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), volumeName);
    }

    public void delete(String projectName, String volumeName) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumeResource(projectName, volumeName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    static {
        Volumes.ajc$preClinit();
    }

    static /* synthetic */ void create_aroundBody0(Volumes volumes, Volumes volumes2, String string, String string2, String string3, JoinPoint joinPoint) {
        volumes2.create(string, string2, string3);
    }

    static /* synthetic */ void create_aroundBody2(Volumes ajc$this, String volumeName, String comment, JoinPoint joinPoint) {
        String string = comment;
        String string2 = volumeName;
        String string3 = ajc$this.client.getDefaultProject();
        Volumes volumes = ajc$this;
        Object[] objectArray = new Object[]{string3, string2, string};
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$this, (Object)volumes, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{ajc$this, volumes, string3, string2, string, joinPoint2};
        OdpsDeprecatedLogger.aspectOf().around(new Volumes$AjcClosure1(objectArray2).linkClosureAndJoinPoint(4112));
    }

    static /* synthetic */ void create_aroundBody4(Volumes ajc$this, String projectName, String volumeName, String comment, JoinPoint joinPoint) {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        String xml = null;
        try {
            xml = JAXBUtils.marshal(model, Volume.VolumeModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        ajc$this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Volumes.java", Volumes.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "create", "com.aliyun.odps.Volumes", "java.lang.String:java.lang.String:java.lang.String", "projectName:volumeName:comment", "com.aliyun.odps.OdpsException", "void"), 219);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "com.aliyun.odps.Volumes", "java.lang.String:java.lang.String", "volumeName:comment", "com.aliyun.odps.OdpsException", "void"), 219);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "com.aliyun.odps.Volumes", "java.lang.String:java.lang.String:java.lang.String", "projectName:volumeName:comment", "com.aliyun.odps.OdpsException", "void"), 236);
    }

    @XmlRootElement(name="Volumes")
    private static class ListVolumesResponse {
        @XmlElement(name="Volume")
        private List<Volume.VolumeModel> volumes = new ArrayList<Volume.VolumeModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListVolumesResponse() {
        }
    }
}

