/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util;

import com.aliyun.odps.commons.util.RetryExceedLimitException;

public class RetryStrategy {
    private static final int DEFAULT_ATTEMPTS = 10;
    private static final int DEFAULT_BACKOFF_INTERVAL = 1;
    private BackoffStrategy strategy;
    private int attempts;
    private int limit;
    private int interval;
    private int initialInterval;
    private int totalBackupTime;

    public RetryStrategy(int limit, int interval, BackoffStrategy strategy) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit must >= 1");
        }
        if (interval < 1) {
            throw new IllegalArgumentException("interval must >= 1");
        }
        this.limit = limit;
        this.initialInterval = interval;
        this.interval = interval;
        this.strategy = strategy;
        this.totalBackupTime = 0;
        this.attempts = 0;
    }

    public RetryStrategy(int attempts, int interval) {
        this(attempts, interval, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy(int attempts) {
        this(attempts, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy() {
        this(10, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public void onFailure(Exception err) throws RetryExceedLimitException {
        if (this.attempts++ >= this.limit) {
            throw new RetryExceedLimitException(this.attempts, (Throwable)err);
        }
        try {
            Thread.sleep(this.interval * 1000);
            this.totalBackupTime += this.interval;
            if (this.strategy.equals((Object)BackoffStrategy.EXPONENTIAL_BACKOFF)) {
                this.interval *= 2;
            }
            if (this.strategy.equals((Object)BackoffStrategy.LINEAR_BACKOFF)) {
                this.interval += this.initialInterval;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getTotalBackupTime() {
        return this.totalBackupTime;
    }

    public static enum BackoffStrategy {
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF,
        CONSTANT_BACKOFF;

    }
}

