/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.proto.XstreamPack;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.datahub.DatahubException;
import com.aliyun.odps.datahub.PackReader$AjcClosure1;
import com.aliyun.odps.datahub.PackReader$AjcClosure3;
import com.aliyun.odps.datahub.PackType;
import com.aliyun.odps.datahub.ReadPackResult;
import com.aliyun.odps.datahub.SeekPackResult;
import com.aliyun.odps.rest.RestClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PackReader {
    private RestClient datahubServiceClient;
    private TableSchema tableSchema;
    private String path;
    private MessageDigest messageDigest;
    private Map<String, String> params;
    private Map<String, String> headers;
    private String currPackId;
    private String nextPackId;
    private PackType.ReadMode readMode;
    private ProtobufRecordStreamReader protobufRecordStreamReader;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public PackReader(RestClient datahubServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers) {
        this(datahubServiceClient, tableSchema, path, params, headers, PackType.FIRST_PACK_ID);
    }

    public PackReader(RestClient datahubServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers, String packId) {
        this.datahubServiceClient = datahubServiceClient;
        this.tableSchema = tableSchema;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.currPackId = null;
        this.nextPackId = null;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.protobufRecordStreamReader = null;
        this.seek(packId, PackType.ReadMode.SEEK_CUR);
    }

    private boolean isValid(String pid) {
        return pid != null && !pid.equals(PackType.FIRST_PACK_ID) && !pid.equals(PackType.LAST_PACK_ID);
    }

    private void seek(String rpid, PackType.ReadMode mode) {
        if ((rpid == null || rpid.equals("")) && mode != PackType.ReadMode.SEEK_BEGIN && mode != PackType.ReadMode.SEEK_END) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        if (mode == PackType.ReadMode.SEEK_NEXT && this.isValid(this.currPackId) && this.currPackId.equals(rpid) && this.isValid(this.nextPackId)) {
            rpid = this.nextPackId;
            mode = PackType.ReadMode.SEEK_CUR;
        } else {
            this.currPackId = null;
        }
        switch (mode) {
            case SEEK_BEGIN: {
                this.nextPackId = PackType.FIRST_PACK_ID;
                break;
            }
            case SEEK_END: {
                this.nextPackId = PackType.LAST_PACK_ID;
                break;
            }
            case SEEK_CUR: 
            case SEEK_NEXT: {
                this.nextPackId = rpid;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pack read mode.");
            }
        }
        this.readMode = mode;
        this.protobufRecordStreamReader = null;
    }

    public SeekPackResult seek(long timeStamp) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            Connection conn;
            params.put("timestamp", Long.toString(timeStamp));
            Connection connection = conn = this.datahubServiceClient.connect(this.path, "GET", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new PackReader$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String json = IOUtils.readStreamAsString(conn.getInputStream());
            JSONObject tree = JSON.parseObject((String)json);
            String node = tree.getString("PackId");
            if (node != null) {
                SeekPackResult startPack = new SeekPackResult(node);
                return startPack;
            }
            throw new DatahubException("get pack id fail");
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatahubException(e.getMessage(), e);
        }
    }

    public ReadPackResult read() throws OdpsException, IOException {
        try {
            return this.read("all");
        }
        catch (DatahubException e) {
            if (e.getErrorCode().equals("OutOfRange")) {
                this.seek(PackType.FIRST_PACK_ID, PackType.ReadMode.SEEK_CUR);
                return this.read("all");
            }
            throw e;
        }
    }

    public ReadPackResult readPackMeta() throws OdpsException, IOException {
        return this.read("meta");
    }

    public Map<String, String> readMeta() throws OdpsException, IOException {
        ReadPackResult result = this.readPackMeta();
        if (result != null) {
            return result.getKvMeta();
        }
        return null;
    }

    private ReadPackResult read(String fetchMode) throws OdpsException, IOException {
        this.protobufRecordStreamReader = null;
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            Connection conn;
            String strMode = this.readMode == PackType.ReadMode.SEEK_NEXT ? "AFTER_PACKID" : "AT_PACKID";
            params.put("packid", this.nextPackId);
            params.put("iteratemode", strMode);
            params.put("packnum", "1");
            params.put("packfetchmode", fetchMode);
            Connection connection = conn = this.datahubServiceClient.connect(this.path, "GET", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new PackReader$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String num = resp.getHeader("x-odps-pack-num");
            if (num.equals("0")) {
                return null;
            }
            InputStream in = conn.getInputStream();
            byte[] bytes = IOUtils.readFully(in);
            XstreamPack.XStreamPack pack = XstreamPack.XStreamPack.parseFrom(bytes);
            ArrayList<Record> records = new ArrayList<Record>();
            if (fetchMode.equals("all")) {
                bytes = pack.getPackData().toByteArray();
                this.protobufRecordStreamReader = new ProtobufRecordStreamReader(this.tableSchema, new ByteArrayInputStream(bytes));
                Record r = null;
                while ((r = this.protobufRecordStreamReader.read()) != null) {
                    records.add(r);
                }
            }
            String npid = resp.getHeader("x-odps-next-packid");
            String cpid = resp.getHeader("x-odps-current-packid");
            long timeStamp = new Long(resp.getHeader("x-odps-pack-timestamp"));
            if (!npid.equals(PackType.LAST_PACK_ID)) {
                this.nextPackId = npid;
                this.readMode = PackType.ReadMode.SEEK_CUR;
                this.currPackId = cpid;
            } else {
                this.nextPackId = cpid;
                this.readMode = PackType.ReadMode.SEEK_NEXT;
                this.currPackId = null;
            }
            HashMap<String, String> kvMap = null;
            if (pack.hasKvMeta()) {
                kvMap = new HashMap<String, String>();
                for (int i = 0; i < pack.getKvMeta().getItemsList().size(); ++i) {
                    XstreamPack.BytesPairPB kv = pack.getKvMeta().getItems(i);
                    kvMap.put(kv.getKey().toStringUtf8(), kv.getValue().toStringUtf8());
                }
            }
            String partitionSpec = null;
            if (null != kvMap) {
                partitionSpec = (String)kvMap.get("__partition__");
            }
            if (pack.hasPackMeta()) {
                return new ReadPackResult(cpid, npid, timeStamp, partitionSpec, records, pack.getPackMeta().toByteArray());
            }
            return new ReadPackResult(cpid, npid, timeStamp, partitionSpec, records, kvMap);
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatahubException(e.getMessage(), e);
        }
    }

    public ReadPackResult read(String packId, PackType.ReadMode mode) throws OdpsException, IOException {
        this.seek(packId, mode);
        return this.read();
    }

    private String generatorMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    static {
        PackReader.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(PackReader packReader, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(PackReader packReader, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PackReader.java", PackReader.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 131);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 201);
    }
}

