/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class RecordSetIterator
implements Iterator<Record> {
    private static final Long FETCH_SIZE = 1000L;
    private InstanceTunnel.DownloadSession session;
    private long recordCount;
    private long cursor = 0L;
    private long fetchSize = 0L;
    private int idx = 0;
    private List<Record> buffer;

    public RecordSetIterator(InstanceTunnel.DownloadSession session, long recordCount) {
        this.session = session;
        this.recordCount = recordCount;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.recordCount;
    }

    @Override
    public Record next() {
        if (this.buffer == null || this.idx == this.buffer.size()) {
            this.fillBuffer();
        }
        ++this.cursor;
        return this.buffer.get(this.idx++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private void fillBuffer() {
        this.idx = 0;
        TunnelRecordReader reader = this.openNewReader();
        this.buffer = new ArrayList<Record>();
        Record r = null;
        try {
            while ((r = reader.read()) != null) {
                this.buffer.add(r);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Read from reader failed:", e);
        }
    }

    private TunnelRecordReader openNewReader() {
        this.fetchSize = this.recordCount - this.cursor <= FETCH_SIZE ? this.recordCount - this.cursor : FETCH_SIZE;
        try {
            return this.session.openRecordReader(this.cursor, this.fetchSize);
        }
        catch (TunnelException e) {
            throw new RuntimeException("Open reader failed:", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Open reader failed:", e);
        }
    }
}

