/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.EmptyIterator;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.task.RecordSetIterator;
import com.aliyun.odps.task.SQLTask$AjcClosure1;
import com.aliyun.odps.task.SQLTask$AjcClosure3;
import com.aliyun.odps.task.SQLTask$AjcClosure5;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.StringUtils;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@XmlRootElement(name="SQL")
public class SQLTask
extends Task {
    private String query;
    private static Map<String, String> defaultHints;
    private static final String AnonymousSQLTaskName = "AnonymousSQLTask";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public String getQuery() {
        return this.query;
    }

    public static void setDefaultHints(Map<String, String> hints) {
        defaultHints = hints;
    }

    public static void removeDefaultHints() {
        defaultHints = null;
    }

    @XmlElement(name="Query")
    public void setQuery(String query) {
        this.query = query;
    }

    @Deprecated
    public static List<Record> getResult(Instance instance, String taskName) throws OdpsException {
        Instance instance2 = instance;
        String string = taskName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)instance2, (Object)string);
        Object[] objectArray = new Object[]{instance2, string, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().around(new SQLTask$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
    }

    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, taskName, limit, true);
    }

    private static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit, boolean limitEnabled) throws OdpsException, IOException {
        Record record;
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        InstanceTunnel.DownloadSession session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), limitEnabled);
        long recordCount = session.getRecordCount();
        ArrayList<Record> records = new ArrayList<Record>();
        if (recordCount == 0L) {
            return records;
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        TunnelRecordReader reader = session.openRecordReader(0L, recordCount);
        while ((record = reader.read()) != null) {
            records.add(record);
        }
        return records;
    }

    public static List<Record> getResultByInstanceTunnel(Instance instance, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, AnonymousSQLTaskName, limit);
    }

    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, taskName, null);
    }

    public static List<Record> getResultByInstanceTunnel(Instance instance) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, AnonymousSQLTaskName);
    }

    @Deprecated
    public static List<Record> getResult(Instance instance) throws OdpsException {
        Instance instance2 = instance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)instance2);
        Object[] objectArray = new Object[]{instance2, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().around(new SQLTask$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
    }

    public static Iterator<Record> getResultSet(Instance instance) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName);
    }

    public static Iterator<Record> getResultSet(Instance instance, String taskName) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, taskName, null);
    }

    public static Iterator<Record> getResultSet(Instance instance, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName, limit);
    }

    public static Iterator<Record> getResultSet(Instance instance, String taskName, Long limit) throws OdpsException {
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        InstanceTunnel.DownloadSession session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), false);
        long recordCount = session.getRecordCount();
        if (recordCount == 0L) {
            return EmptyIterator.emptyIterator();
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        return new RecordSetIterator(session, recordCount);
    }

    private static void checkTaskName(Instance instance, String taskName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)taskName)) {
            throw new OdpsException("Invalid task name.");
        }
        boolean findTask = false;
        for (String n : instance.getTaskNames()) {
            if (!taskName.equals(n)) continue;
            findTask = true;
            break;
        }
        if (!findTask) {
            throw new OdpsException("Invalid task: " + taskName);
        }
    }

    @Override
    public String getCommandText() {
        return this.query;
    }

    public static List<String> getSqlWarning(Instance instance) throws OdpsException {
        return SQLTask.getSqlWarning(instance, AnonymousSQLTaskName);
    }

    public static List<String> getSqlWarning(Instance instance, String taskName) throws OdpsException {
        String warnings = instance.getTaskInfo(taskName, "warnings");
        try {
            return JSON.parseArray((String)JSON.parseObject((String)warnings).getString("warnings"), String.class);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, null, null, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, priority, "sql");
    }

    private static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, Integer priority, String type) throws OdpsException {
        String json;
        SQLTask task = new SQLTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", type);
        if (hints == null) {
            hints = defaultHints;
        }
        if (hints != null) {
            try {
                json = JSON.toJSONString(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = JSON.toJSONString(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (priority != null) {
            return odps.instances().create(project, task, priority);
        }
        return odps.instances().create(project, task);
    }

    static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, String type) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, null, type);
    }

    static {
        SQLTask.ajc$preClinit();
    }

    static /* synthetic */ List getResult_aroundBody0(Instance instance, String taskName, JoinPoint joinPoint) {
        Map<String, String> results = instance.getTaskResults();
        String selectResult = results.get(taskName);
        if (selectResult != null) {
            CsvReader reader = new CsvReader((Reader)new StringReader(selectResult));
            reader.setSafetySwitch(false);
            ArrayList<ArrayRecord> records = new ArrayList<ArrayRecord>();
            int lineCount = 0;
            Column[] columns = new Column[]{};
            try {
                while (reader.readRecord()) {
                    String[] newline = reader.getValues();
                    if (lineCount == 0) {
                        columns = new Column[newline.length];
                        for (int i = 0; i < newline.length; ++i) {
                            columns[i] = new Column(newline[i], OdpsType.STRING);
                        }
                    } else {
                        ArrayRecord record = new ArrayRecord(columns);
                        for (int i = 0; i < newline.length; ++i) {
                            record.set(i, (Object)newline[i]);
                        }
                        records.add(record);
                    }
                    ++lineCount;
                }
            }
            catch (IOException e) {
                throw new OdpsException("Error when parse sql results.", e);
            }
            return records;
        }
        return null;
    }

    static /* synthetic */ List getResult_aroundBody2(Instance instance, String string, JoinPoint joinPoint) {
        return SQLTask.getResult(instance, string);
    }

    static /* synthetic */ List getResult_aroundBody4(Instance instance, JoinPoint joinPoint) {
        String string = AnonymousSQLTaskName;
        Instance instance2 = instance;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)instance2, (Object)string);
        Object[] objectArray = new Object[]{instance2, string, joinPoint2};
        return (List)OdpsDeprecatedLogger.aspectOf().around(new SQLTask$AjcClosure3(objectArray).linkClosureAndJoinPoint(0));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SQLTask.java", SQLTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResult", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String", "instance:taskName", "com.aliyun.odps.OdpsException", "java.util.List"), 117);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "getResult", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String", "instance:taskName", "com.aliyun.odps.OdpsException", "java.util.List"), 312);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResult", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance", "instance", "com.aliyun.odps.OdpsException", "java.util.List"), 312);
    }
}

