/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.PackType;
import com.aliyun.odps.tunnel.io.SeekPackResult;
import com.aliyun.odps.tunnel.io.StreamReader$AjcClosure1;
import com.aliyun.odps.tunnel.io.StreamReader$AjcClosure3;
import com.aliyun.odps.tunnel.io.StreamReader$AjcClosure5;
import com.aliyun.odps.tunnel.io.proto.XstreamPack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Deprecated
public class StreamReader {
    private RestClient tunnelServiceClient;
    private TableSchema tableSchema;
    private String path;
    private MessageDigest messageDigest;
    private Map<String, String> params;
    private Map<String, String> headers;
    private String lastPackId;
    private String nextPackId;
    private PackType.ReadMode readMode;
    private CompressOption compressOption;
    private ProtobufRecordStreamReader protobufRecordStreamReader;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public StreamReader(RestClient tunnelServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers) {
        this(tunnelServiceClient, tableSchema, path, params, headers, PackType.FIRST_PACK_ID);
    }

    public StreamReader(RestClient tunnelServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers, String packId) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.tableSchema = tableSchema;
        this.path = path;
        this.params = params;
        this.headers = headers;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.protobufRecordStreamReader = null;
        this.compressOption = new CompressOption();
        this.seek(packId, PackType.ReadMode.SEEK_CUR);
    }

    public Record read() throws TunnelException, IOException {
        Record r = null;
        do {
            if (this.protobufRecordStreamReader == null) continue;
            try {
                r = this.protobufRecordStreamReader.read();
            }
            catch (IOException e) {
                this.protobufRecordStreamReader = null;
                this.nextPackId = this.lastPackId;
                this.readMode = PackType.ReadMode.SEEK_CUR;
                throw e;
            }
        } while (r == null && this.getPack());
        return r;
    }

    public void skipPack() {
        this.seek(this.lastPackId, PackType.ReadMode.SEEK_NEXT);
    }

    public String getLastPackId() {
        return this.lastPackId;
    }

    private void seek(String rpid, PackType.ReadMode mode) {
        if (rpid == null && !mode.equals((Object)PackType.ReadMode.SEEK_BEGIN) && !mode.equals((Object)PackType.ReadMode.SEEK_END)) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        switch (mode) {
            case SEEK_BEGIN: {
                this.nextPackId = PackType.FIRST_PACK_ID;
                break;
            }
            case SEEK_END: {
                this.nextPackId = PackType.LAST_PACK_ID;
                break;
            }
            case SEEK_CUR: 
            case SEEK_NEXT: {
                this.nextPackId = rpid.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pack read mode.");
            }
        }
        this.readMode = mode;
        this.protobufRecordStreamReader = null;
    }

    public SeekPackResult seek(long timeStamp) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            Connection conn;
            params.put("timestamp", Long.toString(timeStamp));
            Connection connection = conn = this.tunnelServiceClient.connect(this.path, "GET", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamReader$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String json = IOUtils.readStreamAsString(conn.getInputStream());
            JSONObject tree = JSON.parseObject((String)json);
            String node = tree.getString("PackId");
            if (node != null) {
                SeekPackResult startPack = new SeekPackResult(node);
                return startPack;
            }
            throw new TunnelException("get pack id fail");
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    private boolean getPack() throws TunnelException, IOException {
        this.protobufRecordStreamReader = null;
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            Connection conn;
            String strMode = this.readMode.equals((Object)PackType.ReadMode.SEEK_NEXT) ? "AFTER_PACKID" : "AT_PACKID";
            params.put("packid", this.nextPackId);
            params.put("iteratemode", strMode);
            params.put("packnum", "1");
            Connection connection = conn = this.tunnelServiceClient.connect(this.path, "GET", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamReader$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String num = resp.getHeader("x-odps-pack-num");
            if (num.equals("0")) {
                return false;
            }
            InputStream in = conn.getInputStream();
            byte[] bytes = IOUtils.readFully(in);
            XstreamPack.XStreamPack pack = XstreamPack.XStreamPack.parseFrom(bytes);
            bytes = pack.getPackData().toByteArray();
            this.protobufRecordStreamReader = new ProtobufRecordStreamReader(this.tableSchema, new ByteArrayInputStream(bytes), this.compressOption);
            String npid = resp.getHeader("x-odps-next-packid");
            this.lastPackId = resp.getHeader("x-odps-current-packid");
            if (!npid.equals(PackType.LAST_PACK_ID)) {
                this.nextPackId = npid;
                this.readMode = PackType.ReadMode.SEEK_CUR;
            } else {
                this.nextPackId = this.lastPackId;
                this.readMode = PackType.ReadMode.SEEK_NEXT;
            }
            return true;
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    private String generatorMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    static {
        StreamReader.ajc$preClinit();
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new StreamReader$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
    }

    static /* synthetic */ Response getResponse_aroundBody0(StreamReader streamReader, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(StreamReader streamReader, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ void clinit$_aroundBody4(JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StreamReader.java", StreamReader.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 159);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 203);
        ajc$tjp_2 = factory.makeSJP("staticinitialization", (Signature)factory.makeInitializerSig("8", "com.aliyun.odps.tunnel.io.StreamReader"), 0);
    }
}

