/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.VolumeOutputStream$AjcClosure1;
import com.aliyun.odps.tunnel.io.VolumeOutputStream$AjcClosure3;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class VolumeOutputStream
extends OutputStream {
    private Connection conn = null;
    private long totalBytes;
    private OutputStream out;
    private CRC32 crc = new CRC32();
    private final int CHUNK_SIZE = 524288;
    private int chunkOffset;
    private boolean init;
    private Deflater def;
    private boolean isClosed = true;
    Response resp;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VolumeOutputStream(Connection conn, CompressOption option) throws IOException {
        if (option != null) {
            if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) throw new IOException("invalid compression option.");
            this.def = new Deflater();
            this.def.setLevel(option.level);
            this.def.setStrategy(option.strategy);
            this.out = new DeflaterOutputStream(conn.getOutputStream(), this.def);
        } else {
            this.out = conn.getOutputStream();
        }
        this.conn = conn;
        this.init = false;
        this.isClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = ByteBuffer.allocate(1).array();
        bytes[0] = (byte)(b & 0xFF);
        this.write(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (!this.init) {
            this.init = true;
            this.writeInt(524288);
            this.crcInt(524288);
            this.chunkOffset = 0;
        }
        if (this.chunkOffset != 0) {
            int checkSum = (int)this.crc.getValue();
            this.writeInt(checkSum);
        }
        this.out.close();
        try {
            Connection connection = this.conn;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            this.resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new VolumeOutputStream$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
            if (!this.resp.isOK()) {
                InputStream in = this.conn.getInputStream();
                TunnelException err = null;
                if (in == null) {
                    Connection connection2 = this.conn;
                    JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection2);
                    Object[] objectArray2 = new Object[]{this, connection2, joinPoint2};
                    err = new TunnelException(((Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new VolumeOutputStream$AjcClosure3(objectArray2).linkClosureAndJoinPoint(4112))).getMessage());
                } else {
                    err = new TunnelException(this.conn.getInputStream());
                }
                err.setRequestId(this.resp.getHeader("x-odps-request-id"));
                throw new IOException(err);
            }
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
            this.conn.disconnect();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (!this.init) {
            this.init = true;
            this.writeInt(524288);
            this.crcInt(524288);
            this.chunkOffset = 0;
        }
        if (buf == null || buf.length == 0) {
            throw new IOException("Invalid Protobuf Data Buffer!");
        }
        int bytes = 0;
        while (bytes < len) {
            if (this.chunkOffset == 524288) {
                int checkSum = (int)this.crc.getValue();
                this.writeInt(checkSum);
                this.chunkOffset = 0;
                continue;
            }
            int size = len - bytes > 524288 - this.chunkOffset ? 524288 - this.chunkOffset : len - bytes;
            this.out.write(buf, off + bytes, size);
            this.crc.update(buf, off + bytes, size);
            bytes += size;
            this.chunkOffset += size;
        }
        this.totalBytes += (long)len;
    }

    private void writeInt(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
        this.out.write(bytes);
    }

    private void crcInt(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
        this.crc.update(bytes);
    }

    public long getBytes() {
        return this.totalBytes;
    }

    public Response getResp() {
        return this.resp;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static {
        VolumeOutputStream.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(VolumeOutputStream volumeOutputStream, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(VolumeOutputStream volumeOutputStream, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VolumeOutputStream.java", VolumeOutputStream.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 97);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 102);
    }
}

