/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowUtils {
    public static Schema tableSchemaToArrowSchema(TableSchema tableSchema, List<Column> columns) {
        if (columns == null) {
            return ArrowUtils.tableSchemaToArrowSchema(tableSchema);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Column column : columns) {
            Column fieldColumn = tableSchema.getColumn(column.getName());
            fields.add(ArrowUtils.columnToArrowField(fieldColumn));
        }
        return new Schema(fields);
    }

    public static Schema tableSchemaToArrowSchema(TableSchema tableSchema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < tableSchema.getColumns().size(); ++i) {
            fields.add(ArrowUtils.columnToArrowField(tableSchema.getColumn(i)));
        }
        return new Schema(fields);
    }

    private static Field columnToArrowField(Column fieldColumn) {
        String fieldName = fieldColumn.getName();
        TypeInfo typeInfo = fieldColumn.getTypeInfo();
        ArrowType arrowType = ArrowUtils.getArrowType(typeInfo);
        return fieldColumn.isNullable() ? Field.nullable((String)fieldName, (ArrowType)arrowType) : new Field(fieldName, new FieldType(false, arrowType, null, null), null);
    }

    private static ArrowType getArrowType(TypeInfo typeInfo) {
        ArrowType.Utf8 arrowType = null;
        switch (typeInfo.getOdpsType()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                arrowType = new ArrowType.Utf8();
                break;
            }
            case BINARY: {
                arrowType = new ArrowType.Binary();
                break;
            }
            case TINYINT: {
                arrowType = new ArrowType.Int(8, true);
                break;
            }
            case SMALLINT: {
                arrowType = new ArrowType.Int(16, true);
                break;
            }
            case INT: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case BIGINT: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case BOOLEAN: {
                arrowType = new ArrowType.Bool();
                break;
            }
            case FLOAT: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case DOUBLE: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case DECIMAL: {
                arrowType = new ArrowType.Decimal(((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
                break;
            }
            case DATE: {
                arrowType = new ArrowType.Date(DateUnit.DAY);
                break;
            }
            case DATETIME: {
                arrowType = new ArrowType.Date(DateUnit.MILLISECOND);
                break;
            }
            case TIMESTAMP: {
                arrowType = new ArrowType.Timestamp(TimeUnit.NANOSECOND, null);
                break;
            }
            case ARRAY: {
                arrowType = new ArrowType.List();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + typeInfo.getOdpsType());
            }
        }
        return arrowType;
    }
}

