/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Instance;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class QueryInfo {
    private int id = -1;
    private int retry = 0;
    private boolean isSelect = true;
    private String sql;
    private Map<String, String> hint;
    private Instance instance = null;
    private ExecuteMode executeMode = ExecuteMode.INTERACTIVE;
    private List<String> executionLog = new ArrayList<String>();

    QueryInfo(String sql, Map<String, String> hint, ExecuteMode executeMode) {
        this.sql = sql;
        this.hint = hint;
        this.executeMode = executeMode;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetry() {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            return this.retry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRetry() {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            ++this.retry;
        }
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, String> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, String> hint) {
        this.hint = hint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance getInstance() {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            return this.instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteMode getExecuteMode() {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            return this.executeMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuteMode(ExecuteMode mode) {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            this.executeMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(Instance instance, ExecuteMode executeMode, String logview, String rerunMessage) {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            this.instance = instance;
            this.executeMode = executeMode;
            if (!StringUtils.isNullOrEmpty((String)rerunMessage)) {
                this.executionLog.add("Query failed:" + rerunMessage);
                if (executeMode.equals((Object)ExecuteMode.OFFLINE)) {
                    this.executionLog.add("Will fallback to offline mode");
                } else {
                    this.executionLog.add("Will rerun in interactive mode");
                }
            }
            this.executionLog.add("Running in " + executeMode.toString().toLowerCase() + " mode, RetryCount: " + this.retry + ", QueryId:" + this.id + "\nLog view:");
            this.executionLog.add(logview);
        }
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAndCleanExecutionLog() {
        QueryInfo queryInfo = this;
        synchronized (queryInfo) {
            ArrayList<String> log = new ArrayList<String>();
            log.addAll(this.executionLog);
            this.executionLog.clear();
            return log;
        }
    }
}

