/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.PureJavaCrc32C;
import org.xerial.snappy.SnappyFramedInputStream;

public class ArrowHttpInputStream
implements ReadableByteChannel {
    private InputStream in;
    private CompressOption compress;
    private byte[] buf = new byte[0];
    private PureJavaCrc32C chunkCrc = new PureJavaCrc32C();
    private PureJavaCrc32C globalCrc = new PureJavaCrc32C();
    private int crcChunkSize;
    private int readPos;
    private int bufSize;
    private int bufCapacity;
    private boolean isOpen;
    private boolean isLastChunk;

    private static int bytesToInt(byte[] bytes) {
        return ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
    }

    private static int bytesToInt(byte[] bytes, int offset) {
        return ((bytes[offset] & 0xFF) << 24) + ((bytes[1 + offset] & 0xFF) << 16) + ((bytes[2 + offset] & 0xFF) << 8) + (bytes[3 + offset] & 0xFF);
    }

    public ArrowHttpInputStream(InputStream inputStream, CompressOption compress) throws IOException {
        this.in = inputStream;
        this.bufSize = 0;
        this.readPos = 0;
        this.isOpen = true;
        this.isLastChunk = false;
        this.compress = compress;
        if (compress != null && !compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) {
            if (compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = new InflaterInputStream(inputStream);
            } else if (compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = new SnappyFramedInputStream(inputStream);
            } else {
                throw new IOException("invalid compression option.");
            }
        }
    }

    private boolean readChunk() throws IOException {
        byte[] temp;
        if (this.bufSize > this.readPos) {
            return true;
        }
        if (this.buf.length == 0 && this.in.read(temp = new byte[4]) != -1) {
            this.crcChunkSize = ArrowHttpInputStream.bytesToInt(temp);
            this.bufCapacity = this.crcChunkSize + 4;
            this.buf = new byte[this.bufCapacity];
        }
        this.bufSize = 0;
        int byteRead = -1;
        while (this.bufSize < this.bufCapacity && (byteRead = this.in.read(this.buf, this.bufSize, this.bufCapacity - this.bufSize)) != -1) {
            this.bufSize += byteRead;
        }
        if (this.bufSize == 0) {
            return false;
        }
        if (this.bufSize < 4) {
            throw new IOException("InputStream Read() for crc32 failed.");
        }
        int dataSize = this.bufSize - 4;
        int readCheckSum = ArrowHttpInputStream.bytesToInt(this.buf, dataSize);
        int checkSum = 0;
        this.globalCrc.update(this.buf, 0, dataSize);
        if (this.bufSize < this.crcChunkSize + 4) {
            this.isLastChunk = true;
            checkSum = (int)this.globalCrc.getValue();
        } else {
            this.chunkCrc.reset();
            this.chunkCrc.update(this.buf, 0, dataSize);
            checkSum = (int)this.chunkCrc.getValue();
        }
        if (checkSum != readCheckSum) {
            throw new IOException("CRC Check failed.");
        }
        this.bufSize = dataSize;
        this.readPos = 0;
        return true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int totalRead;
        int readBytes;
        if (!this.isOpen) {
            throw new IOException("Operation forbidden on closed BufferReader");
        }
        int len = dst.remaining();
        for (totalRead = 0; totalRead < len && this.readChunk(); totalRead += readBytes) {
            readBytes = Math.min(this.bufSize - this.readPos, len - totalRead);
            dst.put(this.buf, this.readPos, readBytes);
            this.readPos += readBytes;
        }
        return totalRead;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            this.in.close();
        }
    }
}

