/**
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.aliyun.odps.tunnel;

/**
 * Volume Filesystem Error Code
 * 
 * @author Emerson Zhao [mailto:zhenyi.zzy@alibaba-inc.com]
 *
 */
public class VolumeFSErrorCode {

  public static final String NoSuchVolume = "NoSuchObject";
  public static final String NoSuchPath = "NoSuchPath";
  public static final String PathAlreadyExists = "PathAlreadyExists";
  public static final String RequestEntityTooLarge = "RequestEntityTooLarge";
  public static final String RequestedRangeNotSatisfiable = "RequestedRangeNotSatisfiable";
  public static final String InvalidPath = "InvalidPath";
  public static final String InvalidItem = "InvalidItem";
  public static final String NoPermission = "NoPermission";
  public static final String DeleteConflict = "DeleteConflict";
  public static final String NotAcceptableOperation = "NotAcceptableOperation";
  public static final String InvalidSessionId = "InvalidSessionId";
  public static final String InvalidParameter = "InvalidParameter";
  public static final String InconsistentVolume = "InconsistentVolume";
  public static final String VolumeMissing = "VolumeMissing";
  public static final String ParentNotDirectory = "ParentNotDirectory";


}
