/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Tags;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Classification
extends LazyLoad {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(AttributeDefinition.class, (Object)new AttributeDeserializer()).registerTypeHierarchyAdapter(AttributeDefinition.class, (Object)new AttributeSerializer()).registerTypeAdapter(ClassificationModel.class, (Object)new ClassificationModelDeserializer()).registerTypeAdapter(ClassificationModel.class, (Object)new ClassificationModelSerializer()).create();
    ClassificationModel model;
    RestClient client;
    Odps odps;
    Tags tags;

    Classification(ClassificationModel model, Odps odps) {
        this.model = Objects.requireNonNull(model);
        this.odps = Objects.requireNonNull(odps);
        this.client = odps.getRestClient();
        this.tags = new Tags(odps, this);
    }

    public String getProject() {
        this.lazyLoad();
        return this.model.project;
    }

    public String getName() {
        this.lazyLoad();
        return this.model.name;
    }

    public Date getCreatedTime() {
        this.lazyLoad();
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        this.lazyLoad();
        return this.model.lastModifiedTime;
    }

    public String getOwner() {
        this.lazyLoad();
        return this.model.owner;
    }

    public void addAttributeDefinition(String attribute, AttributeDefinition definition) throws OdpsException {
        this.lazyLoad();
        Objects.requireNonNull(attribute);
        Objects.requireNonNull(definition);
        if (this.model.attributes.containsKey(attribute)) {
            throw new IllegalArgumentException("Attribute '" + attribute + "' already exists");
        }
        if (definition.isRequired) {
            throw new IllegalArgumentException("Adding a required attribute is not allowed");
        }
        String resource = ResourceBuilder.buildClassificationResource(this.odps.getDefaultProject(), Objects.requireNonNull(this.getName()));
        ClassificationModel model = this.model.clone();
        model.attributes.clear();
        model.attributes.put(attribute, definition);
        JsonObject root = new JsonObject();
        root.add("ClassificationInput", GSON.toJsonTree((Object)model));
        String body = GSON.toJson((JsonElement)root);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        this.client.request(resource, "PUT", null, headers, body.getBytes());
        this.reload();
    }

    public void setOwner(String owner) {
        this.lazyLoad();
        this.model.owner = Objects.requireNonNull(owner);
    }

    public Map<String, AttributeDefinition> getAttributeDefinitions() {
        this.lazyLoad();
        return new HashMap<String, AttributeDefinition>(this.model.attributes);
    }

    public Tags tags() {
        this.lazyLoad();
        return new Tags(this.odps, this);
    }

    @Override
    public void reload() throws OdpsException {
        JsonParser parser = new JsonParser();
        String resource = ResourceBuilder.buildClassificationResource(this.model.project, this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        String json = new String(resp.getBody(), StandardCharsets.UTF_8);
        JsonElement jsonElement = parser.parse(json);
        if (!jsonElement.isJsonObject()) {
            throw new ReloadException("Expect a JsonObject, but got: " + json);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (!jsonObject.has("Classification")) {
            throw new ReloadException("Expect member 'Classification', but got: " + json);
        }
        this.model = (ClassificationModel)GSON.fromJson(jsonObject.get("Classification"), ClassificationModel.class);
        this.setLoaded(true);
    }

    static class ClassificationModel {
        String project;
        String name;
        String owner;
        Date lastModifiedTime;
        Date createdTime;
        Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

        ClassificationModel() {
        }

        public ClassificationModel clone() {
            ClassificationModel model = new ClassificationModel();
            model.project = this.project;
            model.name = this.name;
            model.owner = this.owner;
            model.lastModifiedTime = this.lastModifiedTime;
            model.createdTime = this.createdTime;
            model.attributes = new HashMap<String, AttributeDefinition>(this.attributes);
            return model;
        }
    }

    static class ClassificationModelDeserializer
    implements JsonDeserializer<ClassificationModel> {
        ClassificationModelDeserializer() {
        }

        public ClassificationModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ClassificationModel model = new ClassificationModel();
            JsonObject src = json.getAsJsonObject();
            if (src.has("Attributes")) {
                model.attributes.clear();
                JsonObject attributes = src.get("Attributes").getAsJsonObject();
                for (Map.Entry entry : attributes.entrySet()) {
                    model.attributes.put((String)entry.getKey(), (AttributeDefinition)context.deserialize((JsonElement)entry.getValue(), AttributeDefinition.class));
                }
            }
            if (src.has("Owner")) {
                model.owner = src.get("Owner").getAsString();
            }
            if (src.has("CreateTime")) {
                model.createdTime = new Date(src.get("CreateTime").getAsLong());
            }
            if (src.has("UpdateTime")) {
                model.lastModifiedTime = new Date(src.get("UpdateTime").getAsLong());
            }
            if (src.has("DatabaseName")) {
                model.project = src.get("DatabaseName").getAsString();
            }
            if (src.has("Name")) {
                model.name = src.get("Name").getAsString();
            }
            return model;
        }
    }

    static class ClassificationModelSerializer
    implements JsonSerializer<ClassificationModel> {
        ClassificationModelSerializer() {
        }

        public JsonElement serialize(ClassificationModel model, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject classification = new JsonObject();
            if (model.attributes != null) {
                JsonObject attributes = new JsonObject();
                for (Map.Entry<String, AttributeDefinition> entry : model.attributes.entrySet()) {
                    attributes.add(entry.getKey(), context.serialize((Object)entry.getValue()));
                }
                classification.add("Attributes", (JsonElement)attributes);
            }
            classification.addProperty("DatabaseName", model.project);
            classification.addProperty("Name", model.name);
            if (model.owner != null) {
                classification.addProperty("Owner", model.owner);
            }
            return classification;
        }
    }

    static class AttributeDeserializer
    implements JsonDeserializer {
        AttributeDeserializer() {
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AttributeDefinition attributeDefinition = null;
            JsonObject src = json.getAsJsonObject();
            AttributeDefinition.AttributeType type = AttributeDefinition.AttributeType.valueOf(src.get("Type").getAsString().toUpperCase());
            switch (type) {
                case STRING: {
                    StringAttributeDefinition.Builder builder = new StringAttributeDefinition.Builder();
                    if (src.has("Constraints")) {
                        JsonObject constraints = src.get("Constraints").getAsJsonObject();
                        if (constraints.has("MaxLength")) {
                            builder.maxLength(constraints.get("MaxLength").getAsInt());
                        }
                        if (constraints.has("MinLength")) {
                            builder.minLength(constraints.get("MinLength").getAsInt());
                        }
                    }
                    attributeDefinition = builder.build();
                    break;
                }
                case INTEGER: {
                    IntegerAttributeDefinition.Builder builder = new IntegerAttributeDefinition.Builder();
                    if (src.has("Constraints")) {
                        JsonObject constraints = src.get("Constraints").getAsJsonObject();
                        if (constraints.has("Maximum")) {
                            builder.maximum(constraints.get("Maximum").getAsInt());
                        }
                        if (constraints.has("Minimum")) {
                            builder.minimum(constraints.get("Minimum").getAsInt());
                        }
                    }
                    attributeDefinition = builder.build();
                    break;
                }
                case ENUM: {
                    EnumAttributeDefinition.Builder builder = new EnumAttributeDefinition.Builder();
                    if (!src.has("Constraints")) break;
                    JsonObject constraints = src.get("Constraints").getAsJsonObject();
                    if (constraints.has("Elements")) {
                        JsonArray elements = constraints.get("Elements").getAsJsonArray();
                        elements.forEach(e -> builder.element(e.getAsString()));
                    }
                    attributeDefinition = builder.build();
                    break;
                }
                case BOOLEAN: {
                    BooleanAttributeDefinition.Builder builder = new BooleanAttributeDefinition.Builder();
                    attributeDefinition = builder.build();
                    break;
                }
            }
            return attributeDefinition;
        }
    }

    static class AttributeSerializer
    implements JsonSerializer<AttributeDefinition> {
        AttributeSerializer() {
        }

        public JsonElement serialize(AttributeDefinition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject attribute = new JsonObject();
            attribute.addProperty("Type", src.type.name().toLowerCase());
            JsonObject constraints = new JsonObject();
            constraints.addProperty("IsRequired", Boolean.valueOf(src.isRequired));
            constraints.addProperty("Unique", Boolean.valueOf(true));
            if (src.pattern != null) {
                constraints.addProperty("Pattern", src.pattern);
            }
            if (src.maxLength != null) {
                constraints.addProperty("MaxLength", (Number)src.maxLength);
            }
            if (src.minLength != null) {
                constraints.addProperty("MinLength", (Number)src.minLength);
            }
            if (src.maximum != null) {
                constraints.addProperty("Maximum", (Number)src.maximum);
            }
            if (src.minimum != null) {
                constraints.addProperty("Minimum", (Number)src.minimum);
            }
            if (src.elements != null) {
                JsonArray elements = new JsonArray();
                for (String element : src.elements) {
                    elements.add((JsonElement)new JsonPrimitive(element));
                }
                constraints.add("Elements", (JsonElement)elements);
            }
            attribute.add("Constraints", (JsonElement)constraints);
            return attribute;
        }
    }

    public static class BooleanAttributeDefinition
    extends AttributeDefinition {
        public BooleanAttributeDefinition(Builder builder) {
            super(builder);
            this.type = AttributeDefinition.AttributeType.BOOLEAN;
        }

        public static class Builder
        extends AttributeDefinition.Builder<Builder> {
            @Override
            public AttributeDefinition build() {
                return new BooleanAttributeDefinition(this);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }

    public static class EnumAttributeDefinition
    extends AttributeDefinition {
        public EnumAttributeDefinition(Builder builder) {
            super(builder);
            this.type = AttributeDefinition.AttributeType.ENUM;
            if (builder.elements != null) {
                this.elements = new HashSet<String>(builder.elements);
            }
        }

        public Set<String> getElements() {
            return this.elements;
        }

        public static class Builder
        extends AttributeDefinition.Builder<Builder> {
            Set<String> elements;

            Builder element(String element) {
                if (this.elements == null) {
                    this.elements = new HashSet<String>();
                }
                this.elements.add(Objects.requireNonNull(element));
                return this.self();
            }

            @Override
            public AttributeDefinition build() {
                return new EnumAttributeDefinition(this);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }

    public static class IntegerAttributeDefinition
    extends AttributeDefinition {
        public IntegerAttributeDefinition(Builder builder) {
            super(builder);
            this.type = AttributeDefinition.AttributeType.INTEGER;
            if (builder.maximum != null) {
                this.maximum = builder.maximum;
            }
            if (builder.minimum != null) {
                this.minimum = builder.minimum;
            }
        }

        public Integer getMaximum() {
            return this.maximum;
        }

        public Integer getMinimum() {
            return this.minimum;
        }

        public static class Builder
        extends AttributeDefinition.Builder<Builder> {
            Integer maximum;
            Integer minimum;

            @Override
            public AttributeDefinition build() {
                return new IntegerAttributeDefinition(this);
            }

            Builder maximum(int maximum) {
                this.maximum = maximum;
                return this.self();
            }

            Builder minimum(int minimum) {
                this.minimum = minimum;
                return this.self();
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }

    public static class StringAttributeDefinition
    extends AttributeDefinition {
        public StringAttributeDefinition(Builder builder) {
            super(builder);
            this.type = AttributeDefinition.AttributeType.STRING;
            if (builder.pattern != null) {
                this.pattern = builder.pattern;
            }
            if (builder.maxLength != null) {
                this.maxLength = builder.maxLength;
            }
            if (builder.minLength != null) {
                this.minLength = builder.minLength;
            }
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public static class Builder
        extends AttributeDefinition.Builder<Builder> {
            String pattern;
            Integer maxLength;
            Integer minLength;

            Builder maxLength(int maxLength) {
                this.maxLength = maxLength;
                return this.self();
            }

            Builder minLength(int minLength) {
                this.minLength = minLength;
                return this.self();
            }

            @Override
            public AttributeDefinition build() {
                return new StringAttributeDefinition(this);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }

    public static abstract class AttributeDefinition {
        AttributeType type;
        boolean isRequired;
        boolean isUnique;
        String pattern;
        Integer maxLength;
        Integer minLength;
        Integer maximum;
        Integer minimum;
        Set<String> elements;

        public AttributeDefinition(Builder<?> builder) {
            this.isRequired = builder.isRequired;
            this.isUnique = builder.isUnique;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        static abstract class Builder<T extends Builder<T>> {
            boolean isRequired = false;
            boolean isUnique = true;

            Builder() {
            }

            Builder required() {
                this.isRequired = true;
                return this.self();
            }

            public abstract AttributeDefinition build();

            protected abstract T self();
        }

        public static enum AttributeType {
            STRING,
            INTEGER,
            BOOLEAN,
            ENUM;

        }
    }
}

