/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.type.TypeInfo;
import java.util.Iterator;
import java.util.List;

class RecordIter<T>
implements Iterator<Record> {
    Iterator<T> iter;
    Column[] columns;
    long offset = 0L;
    long countLimit = -1L;

    RecordIter(Iterator<T> tableIterator, List<String> headers, List<TypeInfo> typeInfos) {
        this.iter = tableIterator;
        this.initColumns(headers, typeInfos);
    }

    @Override
    public boolean hasNext() {
        if (this.countLimit <= -1L) {
            return this.iter.hasNext();
        }
        return this.iter.hasNext() && this.countLimit > 0L;
    }

    @Override
    public Record next() {
        T record = this.iter.next();
        --this.countLimit;
        return this.toRecord(record);
    }

    void setCountLimit(long countLimit) {
        this.countLimit = countLimit;
    }

    void setOffset(long offset) {
        if (offset < this.offset) {
            throw new IllegalArgumentException("The offset to set cannot be less than the current offset");
        }
        if (offset == this.offset) {
            return;
        }
        for (long count = offset - this.offset; count > 0L && this.iter.hasNext(); --count) {
            this.iter.next();
        }
        this.offset = offset;
    }

    Column[] getColumns() {
        return this.columns;
    }

    private void initColumns(List<String> headers, List<TypeInfo> typeInfos) {
        if (headers == null || typeInfos == null) {
            throw new IllegalArgumentException("headers and types should not be null.");
        }
        if (headers.size() != typeInfos.size()) {
            throw new IllegalArgumentException("The length of headers and types should be equal.");
        }
        this.columns = new Column[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            this.columns[i] = new Column(headers.get(i), typeInfos.get(i));
        }
    }

    Record toRecord(T object) {
        return (Record)object;
    }
}

