/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.impl.ConfigurationImpl;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.VolumeInputStream;
import com.aliyun.odps.tunnel.io.VolumeOutputStream;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;

public class VolumeTunnel {
    private ConfigurationImpl config;

    public VolumeTunnel(Odps odps) {
        this.config = new ConfigurationImpl(odps);
    }

    public void setEndpoint(String endpoint) {
        try {
            URI u = new URI(endpoint);
            this.config.setEndpoint(u);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
    }

    public UploadSession createUploadSession(String projectName, String volumeName, String partition) throws TunnelException {
        return new UploadSession(projectName, volumeName, partition);
    }

    public UploadSession getUploadSession(String projectName, String volumeName, String partition, String uploadId) throws TunnelException {
        return new UploadSession(projectName, volumeName, partition, uploadId);
    }

    public DownloadSession createDownloadSession(String projectName, String volumeName, String partition, String fileName) throws TunnelException {
        return new DownloadSession(projectName, volumeName, partition, fileName);
    }

    public DownloadSession getDownloadSession(String projectName, String volumeName, String partition, String fileName, String downloadId) throws TunnelException {
        return new DownloadSession(projectName, volumeName, partition, fileName, downloadId);
    }

    public class DownloadSession {
        private String id;
        private String projectName;
        private String volumeName;
        private String partitionSpec;
        private String fileName;
        private long fileLength = -1L;
        private DownloadStatus status = DownloadStatus.UNKNOWN;
        private ConfigurationImpl conf;
        private RestClient tunnelServiceClient;

        public DownloadSession(String projectName, String volumeName, String partitionSpec, String fileName) throws TunnelException {
            this.conf = VolumeTunnel.this.config;
            this.projectName = projectName;
            this.volumeName = volumeName;
            this.partitionSpec = partitionSpec;
            this.fileName = this.formatFileName(fileName);
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            this.initiate();
        }

        public DownloadSession(String projectName, String volumeName, String partitionSpec, String fileName, String downloadId) throws TunnelException {
            this.conf = VolumeTunnel.this.config;
            this.projectName = projectName;
            this.volumeName = volumeName;
            this.partitionSpec = partitionSpec;
            this.fileName = this.formatFileName(fileName);
            this.id = downloadId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            this.reload();
            if (!(this.volumeName.equalsIgnoreCase(volumeName) && this.partitionSpec.equalsIgnoreCase(partitionSpec) && this.fileName.equalsIgnoreCase(fileName))) {
                throw new TunnelException("volumeName, partitionName or fileName doesn't match whith downloadId.");
            }
        }

        private void initiate() throws TunnelException {
            block13: {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", "volumefile");
                params.put("target", this.projectName + "/" + this.volumeName + "/" + this.partitionSpec + "/" + this.fileName);
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException("Failed to create download session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void reload() throws TunnelException {
            block13: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource() + "/" + this.id, "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public InputStream openInputStream() throws TunnelException, IOException {
            return this.openInputStream(0L, Long.MAX_VALUE, false);
        }

        public InputStream openInputStream(boolean compress) throws TunnelException, IOException {
            return this.openInputStream(0L, Long.MAX_VALUE, compress);
        }

        public InputStream openInputStream(long start, long length) throws TunnelException, IOException {
            return this.openInputStream(start, length, false);
        }

        public InputStream openInputStream(long start, long length, boolean compress) throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            headers.put("x-odps-tunnel-version", String.valueOf(5));
            if (compress) {
                if (this.conf.getCompressOption().algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                    headers.put("Accept-Encoding", "deflate");
                } else {
                    throw new TunnelException("invalid compression option.");
                }
            }
            params.put("data", null);
            params.put("range", "(" + start + "," + length + ")");
            VolumeInputStream vin = null;
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource() + "/" + this.id, "GET", params, headers);
                Response resp = conn.getResponse();
                if (!resp.isOK()) {
                    TunnelException err = new TunnelException(conn.getInputStream());
                    err.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw new IOException(err);
                }
                String content_encoding = resp.getHeader("Content-Encoding");
                if (content_encoding != null) {
                    if (!resp.getHeader("Content-Encoding").equals("deflate")) {
                        throw new TunnelException("invalid content encoding");
                    }
                    this.conf.setCompressOption(new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0));
                    compress = true;
                } else {
                    compress = false;
                }
                CompressOption option = compress ? this.conf.getCompressOption() : null;
                vin = new VolumeInputStream(conn, option);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            return vin;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public String getId() {
            return this.id;
        }

        public DownloadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        private String getResource() {
            StringBuilder sb = new StringBuilder();
            sb.append("/projects/").append(this.projectName).append("/tunnel").append("/downloads");
            return sb.toString();
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                JsonObject jsonObject;
                String json = IOUtils.readStreamAsString(is);
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("DownloadID")) {
                    this.id = tree.get("DownloadID").getAsString();
                }
                if (tree.has("Status")) {
                    this.status = DownloadStatus.valueOf(tree.get("Status").getAsString().toUpperCase());
                }
                if (tree.has("File")) {
                    jsonObject = tree.get("File").getAsJsonObject();
                    if (jsonObject.has("FileName")) {
                        this.fileName = jsonObject.get("FileName").getAsString();
                    }
                    if (jsonObject.has("FileLength")) {
                        this.fileLength = jsonObject.get("FileLength").getAsLong();
                    }
                }
                if (tree.has("Partition")) {
                    jsonObject = tree.get("Partition").getAsJsonObject();
                    if (jsonObject.has("Volume")) {
                        this.volumeName = jsonObject.get("Volume").getAsString();
                    }
                    if (jsonObject.has("Partition")) {
                        this.partitionSpec = jsonObject.get("Partition").getAsString();
                    }
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }

        private String formatFileName(String fileName) throws TunnelException {
            StringBuilder sb = new StringBuilder();
            if (fileName.length() > 0 && fileName.charAt(0) == '/') {
                throw new TunnelException("FileName cann't start with '/', file name is " + fileName);
            }
            boolean preSlash = false;
            for (int pos = 0; pos < fileName.length(); ++pos) {
                if (fileName.charAt(pos) == '/') {
                    if (!preSlash) {
                        sb.append(fileName.charAt(pos));
                    }
                    preSlash = true;
                    continue;
                }
                sb.append(fileName.charAt(pos));
                preSlash = false;
            }
            return sb.toString();
        }
    }

    public static enum DownloadStatus {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED;

    }

    public class UploadSession {
        private String id;
        private String projectName;
        private String volumeName;
        private String partitionSpec;
        private HashMap<String, Long> fileLists = new HashMap();
        private UploadStatus status = UploadStatus.UNKNOWN;
        private ConfigurationImpl conf;
        private RestClient tunnelServiceClient;

        public UploadSession(String projectName, String volumeName, String partitionSpec) throws TunnelException {
            this.conf = VolumeTunnel.this.config;
            this.projectName = projectName;
            this.volumeName = volumeName;
            this.partitionSpec = partitionSpec;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            this.initiate();
        }

        public UploadSession(String projectName, String volumeName, String partitionSpec, String uploadId) throws TunnelException {
            this.conf = VolumeTunnel.this.config;
            this.projectName = projectName;
            this.volumeName = volumeName;
            this.partitionSpec = partitionSpec;
            this.id = uploadId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            this.reload();
        }

        private void initiate() throws TunnelException {
            block13: {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", "volumefile");
                params.put("target", this.projectName + "/" + this.volumeName + "/" + this.partitionSpec + "/");
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException("Failed to create upload session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public OutputStream openOutputStream(String fileName) throws TunnelException, IOException {
            return this.openOutputStream(fileName, false, false);
        }

        public OutputStream openOutputStream(String fileName, boolean compress) throws TunnelException, IOException {
            return this.openOutputStream(fileName, compress, false);
        }

        public OutputStream openOutputStream(String fileName, boolean compress, boolean append) throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "text/plain");
            headers.put("Transfer-Encoding", "chunked");
            headers.put("x-odps-tunnel-version", String.valueOf(5));
            if (compress) {
                if (this.conf.getCompressOption().algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                    headers.put("Content-Encoding", "deflate");
                } else {
                    throw new TunnelException("invalid compression option.");
                }
            }
            fileName = this.formatFileName(fileName);
            params.put("blockid", fileName);
            if (append) {
                params.put("resume", null);
            }
            VolumeOutputStream vout = null;
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource() + "/" + this.id, "POST", params, headers);
                CompressOption option = compress ? this.conf.getCompressOption() : null;
                vout = new VolumeOutputStream(conn, option);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e);
            }
            return vout;
        }

        private void reload() throws TunnelException {
            block13: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource() + "/" + this.id, "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public void commit(String[] files) throws TunnelException, IOException {
            if (files == null) {
                throw new IllegalArgumentException("Invalid argument: files.");
            }
            ArrayList<String> formatFiles = new ArrayList<String>();
            for (String fileId : files) {
                formatFiles.add(this.formatFileName(fileId));
            }
            files = formatFiles.toArray(new String[0]);
            HashMap<String, Boolean> clientFileMap = new HashMap<String, Boolean>();
            for (String fileId : files) {
                clientFileMap.put(fileId, true);
            }
            this.getStatus();
            if (this.fileLists.size() != clientFileMap.size()) {
                throw new TunnelException("File number not match, server: " + this.fileLists.size() + ", client: " + clientFileMap.size());
            }
            for (String fileId : files) {
                if (this.fileLists.containsKey(fileId)) continue;
                throw new TunnelException("File not exits on server, file name is " + fileId);
            }
            this.completeUpload();
        }

        private String formatFileName(String fileName) throws TunnelException {
            StringBuilder sb = new StringBuilder();
            if (fileName.length() > 0 && fileName.charAt(0) == '/') {
                throw new TunnelException("FileName cann't start with '/', file name is " + fileName);
            }
            boolean preSlash = false;
            for (int pos = 0; pos < fileName.length(); ++pos) {
                if (fileName.charAt(pos) == '/') {
                    if (!preSlash) {
                        sb.append(fileName.charAt(pos));
                    }
                    preSlash = true;
                    continue;
                }
                sb.append(fileName.charAt(pos));
                preSlash = false;
            }
            return sb.toString();
        }

        private void completeUpload() throws TunnelException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            int count = 0;
            while (true) {
                ++count;
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource() + "/" + this.id, "PUT", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break;
                    }
                    if (resp.getStatus() == 500 && count < 3) {
                        try {
                            Thread.sleep(2 * count * 1000);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new TunnelException(e.getMessage(), e);
                        }
                    }
                    try {
                        throw new TunnelException(conn.getInputStream());
                    }
                    catch (IOException e) {
                        throw new TunnelException(e.getMessage(), e);
                    }
                    catch (TunnelException e) {
                        throw e;
                    }
                    catch (OdpsException e) {
                        throw new TunnelException(e.getMessage(), e);
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.disconnect();
                    continue;
                }
                break;
            }
        }

        public String getId() {
            return this.id;
        }

        public UploadStatus getStatus() throws TunnelException {
            this.reload();
            return this.status;
        }

        public String[] getFileList() throws TunnelException, IOException {
            this.reload();
            return this.fileLists.keySet().toArray(new String[0]);
        }

        public Long getFileLength(String fileName) throws TunnelException, IOException {
            fileName = this.formatFileName(fileName);
            this.reload();
            if (this.fileLists.containsKey(fileName)) {
                return this.fileLists.get(fileName);
            }
            throw new TunnelException(fileName + " not exists in tunnel server");
        }

        private String getResource() {
            StringBuilder sb = new StringBuilder();
            sb.append("/projects/").append(this.projectName).append("/tunnel").append("/uploads");
            return sb.toString();
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                String json = IOUtils.readStreamAsString(is);
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("UploadID")) {
                    this.id = tree.get("UploadID").getAsString();
                }
                if (tree.has("Status")) {
                    this.status = UploadStatus.valueOf(tree.get("Status").getAsString().toUpperCase());
                }
                this.fileLists.clear();
                if (tree.has("FileList")) {
                    JsonArray node2 = tree.get("FileList").getAsJsonArray();
                    for (int i = 0; i < node2.size(); ++i) {
                        JsonObject fileNode = node2.get(i).getAsJsonObject();
                        String fileName = fileNode.has("FileName") ? fileNode.get("FileName").getAsString() : null;
                        Long fileLength = fileNode.has("FileLength") ? fileNode.get("FileLength").getAsLong() : 0L;
                        this.fileLists.put(fileName, fileLength);
                    }
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum UploadStatus {
        UNKNOWN,
        NORMAL,
        CLOSING,
        CLOSED,
        CANCELED,
        EXPIRED,
        CRITICAL;

    }
}

