/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowUtils {
    public static Schema tableSchemaToArrowSchema(TableSchema tableSchema, List<Column> columns) {
        if (columns == null) {
            return ArrowUtils.tableSchemaToArrowSchema(tableSchema);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Column column : columns) {
            Column fieldColumn = tableSchema.getColumn(column.getName());
            fields.add(ArrowUtils.columnToArrowField(fieldColumn));
        }
        return new Schema(fields);
    }

    public static Schema tableSchemaToArrowSchema(TableSchema tableSchema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < tableSchema.getColumns().size(); ++i) {
            fields.add(ArrowUtils.columnToArrowField(tableSchema.getColumn(i)));
        }
        return new Schema(fields);
    }

    private static Field columnToArrowField(Column fieldColumn) {
        String fieldName = fieldColumn.getName();
        TypeInfo typeInfo = fieldColumn.getTypeInfo();
        return ArrowUtils.convertTypeInfoToArrowField(fieldName, typeInfo, fieldColumn.isNullable());
    }

    private static Field convertTypeInfoToArrowField(String fieldName, TypeInfo typeInfo, boolean nullable) {
        ArrowType arrowType = ArrowUtils.getArrowType(typeInfo);
        return new Field(fieldName, new FieldType(nullable, arrowType, null, null), ArrowUtils.generateSubFields(typeInfo));
    }

    private static List<Field> generateSubFields(TypeInfo typeInfo) {
        if (typeInfo instanceof ArrayTypeInfo) {
            ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
            TypeInfo subti = arrayTypeInfo.getElementTypeInfo();
            return Arrays.asList(ArrowUtils.convertTypeInfoToArrowField("element", subti, true));
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            TypeInfo keyti = mapTypeInfo.getKeyTypeInfo();
            TypeInfo valti = mapTypeInfo.getValueTypeInfo();
            return Arrays.asList(new Field("element", new FieldType(false, (ArrowType)new ArrowType.Struct(), null, null), Arrays.asList(ArrowUtils.convertTypeInfoToArrowField("key", keyti, false), ArrowUtils.convertTypeInfoToArrowField("value", valti, true))));
        }
        if (typeInfo instanceof StructTypeInfo) {
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList<Field> sfields = new ArrayList<Field>();
            List subTypeInfos = structTypeInfo.getFieldTypeInfos();
            List subNames = structTypeInfo.getFieldNames();
            for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                sfields.add(ArrowUtils.convertTypeInfoToArrowField((String)subNames.get(i), (TypeInfo)subTypeInfos.get(i), true));
            }
            return sfields;
        }
        return null;
    }

    private static ArrowType getArrowType(TypeInfo typeInfo) {
        ArrowType.Utf8 arrowType = null;
        switch (typeInfo.getOdpsType()) {
            case JSON: 
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                arrowType = new ArrowType.Utf8();
                break;
            }
            case BINARY: {
                arrowType = new ArrowType.Binary();
                break;
            }
            case TINYINT: {
                arrowType = new ArrowType.Int(8, true);
                break;
            }
            case SMALLINT: {
                arrowType = new ArrowType.Int(16, true);
                break;
            }
            case INT: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case BIGINT: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case BOOLEAN: {
                arrowType = new ArrowType.Bool();
                break;
            }
            case FLOAT: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case DOUBLE: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case DECIMAL: {
                arrowType = new ArrowType.Decimal(((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
                break;
            }
            case DATE: {
                arrowType = new ArrowType.Date(DateUnit.DAY);
                break;
            }
            case DATETIME: {
                arrowType = new ArrowType.Date(DateUnit.MILLISECOND);
                break;
            }
            case TIMESTAMP: {
                arrowType = new ArrowType.Timestamp(TimeUnit.NANOSECOND, null);
                break;
            }
            case ARRAY: {
                arrowType = new ArrowType.List();
                break;
            }
            case INTERVAL_DAY_TIME: {
                arrowType = new ArrowType.Interval(IntervalUnit.DAY_TIME);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                arrowType = new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
                break;
            }
            case STRUCT: {
                arrowType = new ArrowType.Struct();
                break;
            }
            case MAP: {
                arrowType = new ArrowType.Map(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + typeInfo.getOdpsType());
            }
        }
        return arrowType;
    }
}

