/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.rest;

import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.simpleframework.xml.convert.AnnotationStrategy;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.core.Persister;
import com.aliyun.odps.simpleframework.xml.strategy.SimpleTreeStrategy;
import com.aliyun.odps.simpleframework.xml.strategy.Strategy;
import com.aliyun.odps.simpleframework.xml.stream.Format;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import com.aliyun.odps.simpleframework.xml.stream.Style;
import com.aliyun.odps.simpleframework.xml.stream.Verbosity;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SimpleXmlUtils {
    private static final int INDENT = 3;
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final Style IDENTITY_STYLE = new Style(){

        @Override
        public String getElement(String s) {
            return s;
        }

        @Override
        public String getAttribute(String s) {
            return s;
        }
    };
    private static final Format AUTO_ESCAPE_FORMAT = new Format(3, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", IDENTITY_STYLE, Verbosity.HIGH, false);

    public static <T> String marshal(T obj) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy(new SimpleTreeStrategy());
        Persister serializer = new Persister((Strategy)strategy, AUTO_ESCAPE_FORMAT);
        StringWriter out = new StringWriter();
        serializer.write(obj, out);
        return out.toString();
    }

    public static <T> void marshal(T obj, OutputNode outputNode) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy(new SimpleTreeStrategy());
        Persister serializer = new Persister((Strategy)strategy, AUTO_ESCAPE_FORMAT);
        serializer.write(obj, outputNode);
    }

    public static <T> T unmarshal(byte[] xml, Class<T> clazz) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, AUTO_ESCAPE_FORMAT);
        return (T)serializer.read(clazz, (InputStream)new ByteArrayInputStream(xml));
    }

    public static <T> T unmarshal(Response resp, Class<T> clazz) throws Exception {
        if (resp == null || resp.getBody() == null) {
            throw new RuntimeException("Invalid XML to unmarshal.");
        }
        return SimpleXmlUtils.unmarshal(resp.getBody(), clazz);
    }

    public static <T> T unmarshal(InputNode inputNode, Class<T> clazz) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, AUTO_ESCAPE_FORMAT);
        return (T)serializer.read(clazz, inputNode);
    }

    public static class JsonMapConverter
    implements Converter<Map<String, String>> {
        @Override
        public void write(OutputNode node, Map<String, String> value) throws Exception {
            if (value == null) {
                node.remove();
            }
            node.setValue(GsonObjectBuilder.get().toJson(value));
            node.commit();
        }

        @Override
        public Map<String, String> read(InputNode node) throws Exception {
            String value = node.getValue();
            if (value == null) {
                return new HashMap<String, String>();
            }
            return (Map)GsonObjectBuilder.get().fromJson(value, new TypeToken<Map<String, String>>(){}.getType());
        }
    }

    public static class EmptyStringConverter
    implements Converter<String> {
        @Override
        public void write(OutputNode node, String value) throws Exception {
            if (value == null) {
                value = "";
            }
            node.setValue(value);
            node.commit();
        }

        @Override
        public String read(InputNode node) throws Exception {
            String value = node.getValue();
            return value == null ? "" : value;
        }
    }

    public static class EpochConverter
    implements Converter<Date> {
        @Override
        public void write(OutputNode outputNode, Date date) throws Exception {
            outputNode.setValue(String.valueOf(date.getTime() / 1000L));
            outputNode.commit();
        }

        @Override
        public Date read(InputNode node) throws Exception {
            Long seconds = Long.parseLong(node.getValue());
            return new Date(seconds * 1000L);
        }
    }

    public static class DateConverter
    implements Converter<Date> {
        @Override
        public Date read(InputNode inputNode) throws Exception {
            String dateStr = inputNode.getValue();
            try {
                return DateUtils.parseRfc822Date(dateStr);
            }
            catch (ParseException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        public void write(OutputNode outputNode, Date date) throws Exception {
            outputNode.setValue(DateUtils.formatRfc822Date(date));
            outputNode.commit();
        }
    }
}

